/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.relana.model;

import eu.simuline.relana.expressions.Formula;
import eu.simuline.relana.expressions.Operation;
import eu.simuline.relana.model.Deficiency;
import eu.simuline.relana.model.InstanceLocator;
import eu.simuline.relana.model.SInstance;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public final class FlatCInstance {
    static final Comparator<List<String>> PATH_CMP = new Comparator<List<String>>(){

        @Override
        public int compare(List<String> list1, List<String> list2) {
            for (int i = 0; i < Math.min(list1.size(), list2.size()); ++i) {
                int res = list1.get(i).compareTo(list2.get(i));
                if (res == 0) continue;
                return res;
            }
            return list1.size() - list2.size();
        }
    };
    private final Map<List<String>, SInstance> effects;

    public FlatCInstance(Map<List<String>, SInstance> effects) {
        this.effects = effects;
    }

    Map<List<String>, SInstance> getEffects() {
        return this.effects;
    }

    public SInstance getEffect(InstanceLocator loc) {
        return this.getEffect(loc.getPath());
    }

    public SInstance getEffect(List<String> path) {
        return this.effects.get(path);
    }

    public FlatCInstance remove(SInstance serv, Deficiency def) {
        SInstance newServ = serv.remove(def);
        if (newServ == null) {
            return this.substitute(serv, Formula.EMPTY_EXPRESSION);
        }
        Formula.Var newVar = new Formula.Var(newServ, serv.getName());
        return this.substitute(serv, newVar);
    }

    public FlatCInstance add(SInstance serv, Deficiency def) {
        HashSet<Deficiency> defSet = new HashSet<Deficiency>();
        defSet.add(def);
        Formula.Const newConst = new Formula.Const(defSet, serv.getType());
        assert (serv.getType().isValid(defSet));
        if (serv.getType().asSet().size() == 1) {
            return this.substitute(serv, newConst);
        }
        SInstance newServ = serv.add(def);
        Formula.Var newVar = new Formula.Var(newServ, serv.getName());
        HashSet<Formula> args = new HashSet<Formula>();
        args.add(newConst);
        args.add(newVar);
        Formula newComp = Formula.getFormula(Operation.getOperation(Operation.BaseOps.Union).getEval(null), args);
        return this.substitute(serv, newComp);
    }

    FlatCInstance substitute(SInstance serv, Formula form) {
        TreeMap<List<String>, SInstance> effects = new TreeMap<List<String>, SInstance>(PATH_CMP);
        for (Map.Entry<List<String>, SInstance> entry : this.effects.entrySet()) {
            effects.put(entry.getKey(), entry.getValue().substitute(serv, form));
        }
        return new FlatCInstance(effects);
    }

    private InstDef instDefic(SInstance serv) {
        Formula form = serv.getFormula();
        assert (form != null);
        for (int ind = 0; ind < this.effects.keySet().size(); ++ind) {
            Set<SInstance> vars = form.getVars();
            for (SInstance var : vars) {
                if (var.getDistr() == null) continue;
                Set<Deficiency> minDefs = var.getType().getMin();
                assert (!minDefs.isEmpty());
                Iterator<Deficiency> iter = minDefs.iterator();
                return new InstDef(var, iter.next());
            }
            for (SInstance var : vars) {
                Formula varForm = var.getFormula();
                form = form.substitute(var, varForm);
            }
            serv.setFormula(form);
        }
        return null;
    }

    public BigDecimal getProb(List<String> sPath) {
        SInstance serv = this.getEffect(sPath);
        InstDef instDef = this.instDefic(serv);
        if (instDef == null) {
            Set<Deficiency> defs = serv.getFormula().getConst();
            assert (defs != null);
            return defs.isEmpty() ? BigDecimal.ZERO : BigDecimal.ONE;
        }
        BigDecimal cond = instDef.serv.getDistr().getProb(instDef.def);
        FlatCInstance cInstP = this.add(instDef.serv, instDef.def);
        FlatCInstance cInstM = this.remove(instDef.serv, instDef.def);
        return cond.multiply(cInstP.getProb(sPath)).add(BigDecimal.ONE.subtract(cond).multiply(cInstM.getProb(sPath)));
    }

    public String toString() {
        StringBuffer res = new StringBuffer();
        res.append("\n<FlatCInstance><Effects>");
        res.append(this.effects);
        res.append("</Effects>\n</FlatCInstance>\n");
        return res.toString();
    }

    private static class InstDef {
        private final SInstance serv;
        private final Deficiency def;

        InstDef(SInstance serv, Deficiency def) {
            this.serv = serv;
            this.def = def;
        }
    }
}

