/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.relana.model;

import eu.simuline.relana.model.Deficiency;
import java.util.HashSet;
import java.util.Set;

public final class DeficiencyNode {
    private Set<DeficiencyNode> predecessors;
    private Set<DeficiencyNode> successors;
    private final Deficiency deficiency;

    public DeficiencyNode(Deficiency deficiency) {
        this(deficiency, new HashSet<DeficiencyNode>(), new HashSet<DeficiencyNode>());
    }

    public DeficiencyNode(Deficiency deficiency, Set<DeficiencyNode> predecessors, Set<DeficiencyNode> successors) {
        this.deficiency = deficiency;
        this.predecessors = predecessors;
        this.successors = successors;
    }

    public DeficiencyNode(DeficiencyNode node) {
        this(node.deficiency, new HashSet<DeficiencyNode>(node.predecessors), new HashSet<DeficiencyNode>(node.successors));
    }

    public static Set<Deficiency> unwrap(Set<DeficiencyNode> defNodes) {
        HashSet<Deficiency> res = new HashSet<Deficiency>();
        for (DeficiencyNode node : defNodes) {
            res.add(node.getDeficiency());
        }
        return res;
    }

    public Deficiency getDeficiency() {
        return this.deficiency;
    }

    public Set<DeficiencyNode> getPredecessors() {
        return this.predecessors;
    }

    public Set<DeficiencyNode> getSuccessors() {
        return this.successors;
    }

    public void addPredecessor(DeficiencyNode deficiencyNode) {
        this.predecessors.add(deficiencyNode);
    }

    public void addSuccessor(DeficiencyNode deficiencyNode) {
        this.successors.add(deficiencyNode);
    }

    public void addPredecessors(Set<DeficiencyNode> nodes) {
        this.predecessors.addAll(nodes);
    }

    public void addSuccessors(Set<DeficiencyNode> nodes) {
        this.successors.addAll(nodes);
    }

    public void addAll(DeficiencyNode other) {
        if (!other.getDeficiency().equals(this.getDeficiency())) {
            throw new IllegalArgumentException("Deficiencies" + this.getDeficiency() + " and " + other.getDeficiency() + " should coincide. ");
        }
        this.predecessors.addAll(other.getPredecessors());
        this.successors.addAll(other.getSuccessors());
    }

    public DeficiencyNode getInverse() {
        return new DeficiencyNode(this.deficiency, this.successors, this.predecessors);
    }

    public String toString() {
        StringBuffer res = new StringBuffer();
        res.append("\n<DeficiencyNode deficiency=\"");
        res.append(this.deficiency);
        res.append("\">");
        if (!this.predecessors.isEmpty()) {
            res.append("<Predecessors>");
            for (DeficiencyNode node : this.predecessors) {
                res.append(node.getDeficiency().getName());
            }
            res.append("</Predecessors>\n");
        }
        if (!this.successors.isEmpty()) {
            res.append("<Successors>");
            for (DeficiencyNode node : this.successors) {
                res.append(node.getDeficiency().getName());
            }
            res.append("</Successors>\n");
        }
        res.append("</DeficiencyNode>");
        return res.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DeficiencyNode)) {
            return false;
        }
        DeficiencyNode other = (DeficiencyNode)obj;
        return this.getDeficiency().equals(other.getDeficiency()) && this.getPredecessors().equals(other.getPredecessors()) && this.getSuccessors().equals(other.getSuccessors());
    }

    public int hashCode() {
        return this.getDeficiency().hashCode();
    }
}

