/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.relana.model;

import eu.simuline.relana.model.Deficiency;
import eu.simuline.relana.model.SClass;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class DeficiencyMap {
    private final Map<Set<Deficiency>, Deficiency> setOfNew2old;
    private final SClass source;
    private final SClass target;
    private final Set<Deficiency> domain;
    private final Set<Deficiency> range;
    private Set<Deficiency> idDom;

    public static DeficiencyMap getSubclassMap(Map<Set<Deficiency>, Deficiency> setOfNew2old, SClass source, SClass target) {
        DeficiencyMap result = new DeficiencyMap(setOfNew2old, source, target, new HashSet<Deficiency>());
        HashSet<Deficiency> sourceId = new HashSet<Deficiency>(source.getType().asSet());
        sourceId.removeAll(result.getDomain());
        HashSet<Deficiency> rangeId = new HashSet<Deficiency>(target.getType().asSet());
        rangeId.removeAll(result.getRange());
        if (!sourceId.equals(rangeId)) {
            throw new IllegalArgumentException("No subclass map extending " + result + ". ");
        }
        result.idDom = rangeId;
        return result;
    }

    public DeficiencyMap(Map<Set<Deficiency>, Deficiency> setOfNew2old, SClass source, SClass target, Set<Deficiency> idDom) {
        this.setOfNew2old = setOfNew2old;
        this.source = source;
        this.target = target;
        this.idDom = idDom;
        this.domain = new HashSet<Deficiency>(this.idDom);
        for (Set<Deficiency> setDef : this.setOfNew2old.keySet()) {
            this.domain.addAll(setDef);
        }
        this.range = new HashSet<Deficiency>(this.idDom);
        this.range.addAll(this.setOfNew2old.values());
        this.checkInvImg01();
        Set<Deficiency> domain = this.getDomain();
        if (!this.source.getType().asSet().containsAll(domain)) {
            throw new IllegalArgumentException("Domain " + domain + " not inside type range " + this.source.getType().asSet() + ". ");
        }
        int num = this.idDom.size();
        for (Set<Deficiency> setDef : this.setOfNew2old.keySet()) {
            num += setDef.size();
        }
        if (num != domain.size()) {
            throw new IllegalArgumentException("Inverse images " + this.setOfNew2old.keySet() + " and identity domain " + this.idDom + " are not pairwise disjoint. ");
        }
        Set<Deficiency> range = this.getRange();
        if (!this.target.getType().asSet().containsAll(range)) {
            throw new IllegalArgumentException("Range " + range + " not inside type range " + this.target.getType().asSet() + ". ");
        }
        if (this.setOfNew2old.size() + this.idDom.size() != range.size()) {
            throw new IllegalArgumentException("Images " + this.setOfNew2old.values() + " and identity domain " + this.idDom + " are not pairwise disjoint. ");
        }
    }

    void checkInvImg01() {
        Iterator<Map.Entry<Set<Deficiency>, Deficiency>> iter = this.setOfNew2old.entrySet().iterator();
        block4: while (iter.hasNext()) {
            Map.Entry<Set<Deficiency>, Deficiency> mapEntry = iter.next();
            Set<Deficiency> setDef = mapEntry.getKey();
            switch (setDef.size()) {
                case 0: {
                    throw new IllegalArgumentException("Found empty inverse image for " + mapEntry.getValue() + ". ");
                }
                case 1: {
                    Deficiency def = this.setOfNew2old.get(setDef);
                    if (!setDef.contains(def)) continue block4;
                    iter.remove();
                    this.idDom.add(def);
                    continue block4;
                }
            }
        }
    }

    public static DeficiencyMap identity(SClass sourceTarget) {
        System.out.println("sourceTarget: " + sourceTarget);
        DeficiencyMap map = sourceTarget.getDeficiencyMap();
        Set<Deficiency> idDom = map == null ? new HashSet<Deficiency>(sourceTarget.getDeclaredDeficiency2ordering().keySet()) : map.getDomain();
        return new DeficiencyMap(new HashMap<Set<Deficiency>, Deficiency>(), sourceTarget, sourceTarget, idDom);
    }

    public DeficiencyMap getInverse() {
        if (this.getDomain().size() != this.getRange().size()) {
            throw new UnsupportedOperationException("This map is not invertible: " + this + ". ");
        }
        HashMap<Set<Deficiency>, Deficiency> invSetOfNew2old = new HashMap<Set<Deficiency>, Deficiency>();
        for (Map.Entry<Set<Deficiency>, Deficiency> entry : this.setOfNew2old.entrySet()) {
            assert (entry.getKey().size() == 1);
            HashSet<Deficiency> oneDefSet = new HashSet<Deficiency>();
            oneDefSet.add(entry.getValue());
            Deficiency def = entry.getKey().iterator().next();
            invSetOfNew2old.put(oneDefSet, def);
        }
        return new DeficiencyMap(invSetOfNew2old, this.target, this.source, this.idDom);
    }

    public DeficiencyMap compose(DeficiencyMap second) {
        if (this.target != second.source) {
            throw new IllegalArgumentException("Composition of maps is allowed only if source and target coincide but found " + second.source.getName() + " and " + this.target.getName() + ". ");
        }
        HashMap<Set<Deficiency>, Deficiency> setOfNew2old = new HashMap<Set<Deficiency>, Deficiency>();
        for (Map.Entry<Set<Deficiency>, Deficiency> entry : second.setOfNew2old.entrySet()) {
            Set<Deficiency> invImg = this.cont(entry.getKey());
            setOfNew2old.put(invImg, entry.getValue());
        }
        for (Map.Entry<Set<Deficiency>, Deficiency> entry : this.setOfNew2old.entrySet()) {
            if (!second.idDom.contains(entry.getValue())) continue;
            setOfNew2old.put(entry.getKey(), entry.getValue());
        }
        HashSet<Deficiency> idDom = new HashSet<Deficiency>(this.idDom);
        idDom.retainAll(second.idDom);
        Iterator iter = setOfNew2old.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (((Set)entry.getKey()).size() != 1) continue;
            assert (((Set)entry.getKey()).size() == 1);
            Deficiency cand = (Deficiency)((Set)entry.getKey()).iterator().next();
            if (!cand.equals(entry.getValue())) continue;
            idDom.add(cand);
            iter.remove();
        }
        return new DeficiencyMap(setOfNew2old, this.source, second.target, idDom);
    }

    public Deficiency map(Deficiency def) {
        if (this.idDom.contains(def)) {
            return def;
        }
        for (Map.Entry<Set<Deficiency>, Deficiency> entry : this.setOfNew2old.entrySet()) {
            if (!entry.getKey().contains(def)) continue;
            return entry.getValue();
        }
        return null;
    }

    Set<Deficiency> getInverseImage(Deficiency def) {
        HashSet<Deficiency> result = new HashSet<Deficiency>();
        if (this.idDom.contains(def)) {
            result.add(def);
            return result;
        }
        for (Map.Entry<Set<Deficiency>, Deficiency> entry : this.setOfNew2old.entrySet()) {
            if (!entry.getValue().equals(def)) continue;
            return entry.getKey();
        }
        return result;
    }

    Set<Deficiency> getDomain() {
        return this.domain;
    }

    Set<Deficiency> getRange() {
        return this.range;
    }

    public SClass getSource() {
        return this.source;
    }

    public SClass getTarget() {
        return this.target;
    }

    public boolean isIsotone() {
        for (Deficiency def1 : this.getDomain()) {
            Set<Deficiency> cone = this.source.getType().getCone(def1);
            if (!this.getDomain().containsAll(cone)) {
                return false;
            }
            for (Deficiency def2 : cone) {
                if (this.target.getType().implies(this.map(def1), this.map(def2))) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isTwistIsotone() {
        for (Deficiency def1 : this.getDomain()) {
            Set<Deficiency> cone = this.source.getType().getCone(def1);
            Set<Deficiency> coneT = this.target.getType().getCone(this.map(def1));
            for (Deficiency defT2 : coneT) {
                HashSet<Deficiency> inter = new HashSet<Deficiency>(this.getInverseImage(defT2));
                inter.retainAll(cone);
                if (!inter.isEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    public Set<Deficiency> cov(Set<Deficiency> defs) {
        assert (this.source.getType().isValid(defs));
        HashSet<Deficiency> defsToMap = new HashSet<Deficiency>(defs);
        defsToMap.retainAll(this.domain);
        HashSet<Deficiency> result = new HashSet<Deficiency>();
        for (Map.Entry<Set<Deficiency>, Deficiency> entry : this.setOfNew2old.entrySet()) {
            HashSet inter = new HashSet(entry.getKey());
            inter.retainAll(defsToMap);
            if (inter.isEmpty()) continue;
            result.add(entry.getValue());
        }
        defsToMap.retainAll(this.target.getType().asSet());
        result.addAll(defsToMap);
        assert (this.target.getType().isValid(result));
        return result;
    }

    public Set<Deficiency> cont(Set<Deficiency> defs) {
        assert (this.target.getType().isValid(defs));
        HashSet<Deficiency> result = new HashSet<Deficiency>();
        for (Map.Entry<Set<Deficiency>, Deficiency> entry : this.setOfNew2old.entrySet()) {
            if (!defs.contains(entry.getValue())) continue;
            result.addAll((Collection)entry.getKey());
        }
        HashSet<Deficiency> defsToMap = new HashSet<Deficiency>(this.source.getType().asSet());
        defsToMap.retainAll(defs);
        result.addAll(defsToMap);
        assert (this.source.getType().isValid(result));
        return result;
    }

    public String toString() {
        StringBuffer res = new StringBuffer();
        res.append("<DeficiencyMap source=\"");
        res.append(this.source.getPathName());
        res.append("\" target=\"");
        res.append(this.target.getPathName());
        res.append("\">\n");
        res.append(this.setOfNew2old);
        res.append('\n');
        res.append(this.idDom);
        res.append("\n</DeficiencyMap>");
        return res.toString();
    }
}

