/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.relana.model;

import eu.simuline.relana.model.CClass;
import eu.simuline.relana.model.CClassLink;
import eu.simuline.relana.model.ClassLocator;
import eu.simuline.relana.model.Package;
import eu.simuline.relana.model.SClass;
import eu.simuline.relana.model.SClassLoader;
import eu.simuline.relana.parser.CClassParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.antlr.v4.runtime.RecognitionException;

public final class CClassLoader {
    private final URL library;
    private final Map<ClassLocator, CClassLink> name2class;
    private final Stack<ClassLocator> unresolvedClasses;
    private final SClassLoader scLoader;

    public CClassLoader(URL library) {
        this.library = library;
        this.name2class = new HashMap<ClassLocator, CClassLink>();
        this.name2class.put(new ClassLocator("Component", Package.BUILD_IN), CClass.COMPONENT);
        this.unresolvedClasses = new Stack();
        this.scLoader = new SClassLoader(this.library);
    }

    public SClass loadSClass(ClassLocator loc, Package pkg) throws IOException, RecognitionException {
        return this.scLoader.loadSClass(loc, pkg);
    }

    public CClass loadCClass(ClassLocator loc, Package pkg) throws IOException, RecognitionException {
        URL url = null;
        List<String> pkgPath = pkg.getPath();
        ArrayList<String> path = new ArrayList<String>(pkgPath);
        path.add("_");
        path.addAll(loc.getPath());
        for (int i = pkgPath.size(); i >= 0; --i) {
            path.remove(i);
            ClassLocator currLoc = ClassLocator.getLocator(path);
            CClassLink cClass = this.name2class.get(currLoc);
            if (cClass != null && cClass.isResolved()) {
                return (CClass)cClass;
            }
            try {
                url = new URL(this.library + currLoc.getPackage().getPathName().replace('.', '/') + currLoc.getName() + ".ccl");
                File clsDoc = new File(url.toURI());
                if (!clsDoc.exists()) continue;
                return this.loadCClass(currLoc);
            }
            catch (URISyntaxException e) {
                throw new IOException("Could not locate file because no uri: " + url + ". ");
            }
        }
        throw new IOException("No appropriate class file found. ");
    }

    public CClass loadCClass(ClassLocator loc) throws IOException, RecognitionException {
        this.resolveLocInOcc(loc, null);
        while (!this.unresolvedClasses.empty()) {
            ClassLocator loc2 = this.unresolvedClasses.pop();
            InputStream str = new URL(this.library + loc2.getPackage().getPathName().replace('.', '/') + loc2.getName() + ".ccl").openStream();
            CClassParser ccParser = new CClassParser(str);
            ccParser.setClassLoader(this);
            CClass cClass = ccParser.getCClass(loc2);
            ClassResolver res = (ClassResolver)this.name2class.put(loc2, cClass);
            for (Occurrence occ : res.resolvationPoints()) {
                this.name2class.get(occ.getLoc()).setComponent(occ.compName(), cClass);
            }
        }
        CClass cClass = (CClass)this.resolveLocInOcc(loc, null);
        cClass.verify();
        return cClass;
    }

    public CClassLink resolveLocInOcc(ClassLocator toBeResolved, ClassLocator loc, String comp) {
        return this.resolveLocInOcc(toBeResolved, new Occurrence(loc, comp));
    }

    private CClassLink resolveLocInOcc(ClassLocator loc, Occurrence occ) {
        CClassLink resolvation = this.name2class.get(loc);
        if (resolvation == null) {
            resolvation = new ClassResolver(loc);
            this.unresolvedClasses.push(loc);
            this.name2class.put(loc, resolvation);
        }
        if (occ != null) {
            resolvation.addOccurrence(occ);
        }
        return resolvation;
    }

    static class ClassResolver
    implements CClassLink {
        private final ClassLocator loc;
        private final Set<Occurrence> occurences;

        ClassResolver(ClassLocator loc) {
            this.loc = loc;
            this.occurences = new HashSet<Occurrence>();
        }

        @Override
        public String getName() {
            return this.loc.getName();
        }

        @Override
        public void addOccurrence(Occurrence occ) {
            this.occurences.add(occ);
        }

        Set<Occurrence> resolvationPoints() {
            return this.occurences;
        }

        @Override
        public boolean isResolved() {
            return false;
        }

        @Override
        public CClassLink setComponent(String name, CClass cClass) {
            return null;
        }

        public String toString() {
            StringBuffer res = new StringBuffer();
            res.append("<ClassResolver>\n");
            res.append(this.loc.toString());
            res.append('\n');
            res.append(this.occurences.toString());
            res.append("\n</ClassResolver>");
            return res.toString();
        }
    }

    static final class Occurrence {
        private final ClassLocator loc;
        private final String component;

        Occurrence(ClassLocator loc, String component) {
            this.loc = loc;
            this.component = component;
        }

        ClassLocator getLoc() {
            return this.loc;
        }

        String compName() {
            return this.component;
        }

        public String toString() {
            StringBuffer res = new StringBuffer();
            res.append("<Occurrence>");
            res.append(this.loc.toString());
            res.append(this.component);
            res.append("</Occurrence>");
            return res.toString();
        }

        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        public int hashCode() {
            return super.hashCode();
        }
    }
}

