/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.relana.model;

import eu.simuline.relana.expressions.FormulaDecl;
import eu.simuline.relana.model.CClassLink;
import eu.simuline.relana.model.CClassLoader;
import eu.simuline.relana.model.CInstance;
import eu.simuline.relana.model.DeficiencyMap;
import eu.simuline.relana.model.MapDecl;
import eu.simuline.relana.model.Package;
import eu.simuline.relana.model.ProbDistr;
import eu.simuline.relana.model.SClass;
import eu.simuline.relana.model.SInstance;
import eu.simuline.relana.model.VerifyException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class CClass
implements CClassLink {
    public static final CClass COMPONENT = new CClass("Component", Package.BUILD_IN, null, (Map)new HashMap(), (Map)new HashMap(), (Map)new HashMap()){

        @Override
        public MapDecl getMapDecl(String name) {
            return null;
        }

        @Override
        public CClassLink getComponentCls(String name) {
            return null;
        }

        @Override
        public SClassDecl getEffectDecl(String name) {
            return null;
        }

        @Override
        public CInstance getInstance() {
            return new CInstance();
        }

        @Override
        Set<String> getComponentNames() {
            return new TreeSet<String>();
        }

        @Override
        Set<String> getEffectNames() {
            return new TreeSet<String>();
        }

        @Override
        void verify() throws VerifyException {
        }
    };
    private final String cName;
    private final Package pkg;
    private final CClass superClass;
    private final Map<String, MapDecl> maps;
    private final Map<String, CClassLink> subComponents;
    private final Map<String, SClassDecl> effects;

    public static CClass getCClass(String cName, Package pkg, CClass superClass, Map<String, MapDecl> maps, Map<String, CClassLink> subComponents, Map<String, SClassDecl> effects) {
        return new CClass(cName, pkg, superClass, maps, subComponents, effects);
    }

    public CClass(String cName, Package pkg, CClass superClass, Map<String, MapDecl> maps, Map<String, CClassLink> subComponents, Map<String, SClassDecl> effects) {
        this.cName = cName;
        this.pkg = pkg;
        this.superClass = superClass;
        this.maps = maps;
        this.subComponents = subComponents;
        this.effects = effects;
    }

    @Override
    public final String getName() {
        return this.cName;
    }

    public final Package getPackage() {
        return this.pkg;
    }

    public final CClass getSuperClass() {
        return this.superClass;
    }

    public MapDecl getMapDecl(String name) {
        MapDecl result = this.maps.get(name);
        if (result != null) {
            return result;
        }
        return this.getSuperClass().getMapDecl(name);
    }

    private Map<String, CClassLink> getName2ComponentClss() {
        return this.subComponents;
    }

    public CClassLink getComponentCls(String name) {
        CClassLink result = this.subComponents.get(name);
        if (result != null) {
            return result;
        }
        return this.getSuperClass().getComponentCls(name);
    }

    public final CClassLink getComponentCls(List<String> path) {
        CClass curr = this;
        for (String key : path) {
            curr = (CClass)curr.getComponentCls(key);
        }
        return curr;
    }

    Set<String> getComponentNames() {
        TreeSet<String> result = new TreeSet<String>(this.getSuperClass().getComponentNames());
        result.addAll(this.getName2ComponentClss().keySet());
        return result;
    }

    public SClassDecl getEffectDecl(String name) {
        SClassDecl result = this.effects.get(name);
        if (result != null) {
            return result;
        }
        return this.getSuperClass().getEffectDecl(name);
    }

    public final SClassDecl getEffectDecl(List<String> path) {
        int ind;
        CClass curr = this;
        for (ind = 0; ind < path.size() - 1; ++ind) {
            curr = (CClass)curr.getComponentCls(path.get(ind));
        }
        return curr.getEffectDecl(path.get(ind));
    }

    private Map<String, SClassDecl> getName2Effects() {
        return this.effects;
    }

    Set<String> getEffectNames() {
        TreeSet<String> result = new TreeSet<String>(this.getSuperClass().getEffectNames());
        result.addAll(this.getName2Effects().keySet());
        return result;
    }

    public final Set<SClassDecl> getEffectsRec() {
        HashSet<SClassDecl> res = new HashSet<SClassDecl>();
        for (SClassDecl decl : this.effects.values()) {
            res.add(decl);
        }
        return res;
    }

    @Override
    public final CClassLink setComponent(String name, CClass cClass) {
        return this.subComponents.put(name, cClass);
    }

    void verify() throws VerifyException {
        this.getSuperClass().verify();
        for (Map.Entry<String, SClassDecl> entry : this.getName2Effects().entrySet()) {
            SClassDecl overwrite = entry.getValue();
            SClassDecl overwritten = this.getSuperClass().getEffectDecl(entry.getKey());
            if (overwrite.isRedeclare()) {
                SClass currentSCls;
                if (overwritten == null) {
                    throw new VerifyException("Found effect \"" + entry.getKey() + "\" redeclared in class \"" + this.getName() + "\" without being declared in any superclass. ");
                }
                if (overwritten.isOutput() && !overwrite.isOutput() || overwritten.isInput() && !overwrite.isInput()) {
                    throw new VerifyException("Weakened access priviligies of effect \"" + entry.getKey() + "\" by redeclaration in class " + this.getName() + ". ");
                }
                DeficiencyMap compMap = DeficiencyMap.identity(currentSCls);
                assert (compMap.getTarget() == overwrite.getSClass());
                for (currentSCls = overwrite.getSClass(); currentSCls != overwritten.getSClass(); currentSCls = currentSCls.getSuperClass()) {
                    assert (compMap.getSource() == currentSCls);
                    if (currentSCls.getSuperClass() == null) {
                        throw new VerifyException("Redeclared effect \"" + entry.getKey() + "\" of class " + overwritten.getSClass().getName() + " as " + overwrite.getSClass().getName() + " which is no subclass. ");
                    }
                    compMap = compMap.compose(currentSCls.getDeficiencyMap());
                }
                continue;
            }
            if (overwritten == null) continue;
            throw new VerifyException("Found effect \"" + entry.getKey() + "\" declared in class \"" + this.getName() + "\" and in a superclass: " + entry.getKey() + "; consider redeclare. ");
        }
        TreeSet<String> names = new TreeSet<String>(this.getSuperClass().getComponentNames());
        names.retainAll(this.getName2ComponentClss().keySet());
        if (!names.isEmpty()) {
            throw new VerifyException("Found components declared in class \"" + this.getName() + "\" and in a superclass: " + names + ". ");
        }
    }

    public CInstance getInstance() {
        CInstance cInstance = this.getSuperClass().getInstance();
        for (Map.Entry<String, CClassLink> cEntry : this.subComponents.entrySet()) {
            CClass cClass = (CClass)cEntry.getValue();
            cInstance.addComponent(cEntry.getKey(), cClass.getInstance());
        }
        HashMap<SClassDecl, SInstance> declWithFormulae = new HashMap<SClassDecl, SInstance>();
        for (Map.Entry<String, SClassDecl> entry : this.effects.entrySet()) {
            SClassDecl decl = entry.getValue();
            SInstance sInstance = decl.getSInstance();
            cInstance.addEffect(entry.getKey(), sInstance);
            if (decl.getFormulaDecl() == null) continue;
            declWithFormulae.put(decl, sInstance);
        }
        for (Map.Entry<String, SClassDecl> entry : declWithFormulae.entrySet()) {
            ((SInstance)((Object)entry.getValue())).setFormula(((SClassDecl)((Object)entry.getKey())).getFormulaDecl().resolve(cInstance));
        }
        return cInstance;
    }

    @Override
    public void addOccurrence(CClassLoader.Occurrence occ) {
    }

    @Override
    public final boolean isResolved() {
        return true;
    }

    public final String toString() {
        StringBuffer res = new StringBuffer();
        res.append("\n<CClass name=\"");
        res.append(this.cName);
        res.append("\" package=\"");
        res.append(this.pkg);
        res.append("\" superClass=\"");
        res.append(this.superClass.getName());
        res.append("\">\n");
        for (Map.Entry<String, MapDecl> entry : this.maps.entrySet()) {
            res.append("<map name=\"");
            res.append(entry.getKey());
            res.append("\"/>\n");
            res.append(entry.getValue());
            res.append("</map>");
        }
        for (Map.Entry<String, Object> entry : this.subComponents.entrySet()) {
            res.append("<component name=\"");
            res.append(entry.getKey());
            res.append("\" class=\"");
            res.append(((CClassLink)entry.getValue()).getName());
            res.append("\"/>\n");
        }
        res.append("\n<effects>");
        for (SClassDecl sClassDecl : this.effects.values()) {
            res.append(sClassDecl.toString());
        }
        res.append("\n</effects>\n</CClass>\n");
        return res.toString();
    }

    public static final class SClassDecl {
        private final boolean isRedeclare;
        private final Set<SClassModifier> modifiers;
        private final SClass sClass;
        private final String name;
        private final ProbDistr distr;
        private FormulaDecl form;

        public SClassDecl(boolean isRedeclare, Set<SClassModifier> modifiers, SClass sClass, String name, ProbDistr distr) {
            this.isRedeclare = isRedeclare;
            this.modifiers = modifiers;
            this.sClass = sClass;
            this.name = name;
            this.distr = distr;
            if (this.isInput() && this.distr != null) {
                throw new IllegalArgumentException("SClass " + name + " is declared as input and at the same time a probability distribution is attached. ");
            }
        }

        public void setFormula(FormulaDecl form) {
            this.form = form;
            if (this.isInput() && this.form != null) {
                throw new IllegalArgumentException("SClass " + this.name + " is declared as input and at the same time a formula is attached. ");
            }
            if (this.distr != null && this.form != null) {
                throw new IllegalArgumentException("Either a probability distribution may be given or a formula but not both. ");
            }
            if (this.form != null && !this.form.retType().equals(this.sClass.getType())) {
                throw new IllegalArgumentException("Tried to assign formula \"" + this.form + "\" with return type " + this.form.retType() + " to variable \"" + this.name + "\" with type " + this.sClass.getType() + " which is not assignment compatible. ");
            }
        }

        public SClass getSClass() {
            return this.sClass;
        }

        public String getName() {
            return this.name;
        }

        public boolean isInput() {
            return this.modifiers.contains((Object)SClassModifier.INPUT);
        }

        public boolean isOutput() {
            return this.modifiers.contains((Object)SClassModifier.OUTPUT);
        }

        public boolean isRedeclare() {
            return this.isRedeclare;
        }

        ProbDistr getProbDistr() {
            return this.distr;
        }

        FormulaDecl getFormulaDecl() {
            return this.form;
        }

        SInstance getSInstance() {
            return new SInstance(this.getSClass().getType(), this.getProbDistr(), this.getName());
        }

        public String toString() {
            StringBuffer res = new StringBuffer();
            res.append('\n');
            if (this.isRedeclare) {
                res.append("redeclare");
            }
            res.append(this.modifiers);
            res.append(this.getSClass().getName());
            res.append(this.getName());
            if (this.distr != null) {
                res.append(" distr: ");
                res.append(this.distr.toString());
            }
            if (this.form != null) {
                res.append(" formula: ");
                res.append(this.form.toString());
            }
            return res.toString();
        }

        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        public int hashCode() {
            return super.hashCode();
        }
    }

    public static enum SClassModifier {
        INPUT,
        OUTPUT;

        static final Map<String, SClassModifier> NAME2MOD;

        public static SClassModifier get(String name) {
            SClassModifier res = NAME2MOD.get(name);
            if (res == null) {
                throw new IllegalArgumentException("Unknown access modifier: \"" + name + "\". ");
            }
            return res;
        }

        static {
            NAME2MOD = new HashMap<String, SClassModifier>();
            NAME2MOD.put("input", INPUT);
            NAME2MOD.put("output", OUTPUT);
        }
    }
}

