/*
 * Decompiled with CFR 0.152.
 */
package eu.simuline.relana.expressions;

import eu.simuline.relana.expressions.Formula;
import eu.simuline.relana.expressions.Operation;
import eu.simuline.relana.expressions.Type;
import eu.simuline.relana.model.CClass;
import eu.simuline.relana.model.CInstance;
import eu.simuline.relana.model.Deficiency;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class FormulaDecl {
    private FormulaDecl() {
    }

    public static FormulaDecl getConst(Type type, Set<Deficiency> val) {
        return new Const(type, val);
    }

    public static FormulaDecl getVar(CClass.SClassDecl decl, List<String> path) {
        return new Var(decl, path);
    }

    public static FormulaDecl getComp(Operation oper, Set<FormulaDecl> args) {
        return new Comp(oper, args);
    }

    public abstract Type retType();

    public abstract Formula resolve(CInstance var1);

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    static final class Comp
    extends FormulaDecl {
        private final Operation oper;
        private final Set<FormulaDecl> args;

        Comp(Operation oper, Set<FormulaDecl> args) {
            this.oper = oper;
            this.args = args;
            this.retType();
        }

        @Override
        public Type retType() {
            return this.oper.retType(this.args);
        }

        @Override
        public Formula resolve(CInstance cInst) {
            HashSet<Formula> fArgs = new HashSet<Formula>();
            for (FormulaDecl decl : this.args) {
                fArgs.add(decl.resolve(cInst));
            }
            return Formula.getFormula(this.oper.getEval(this.retType()), fArgs);
        }

        public String toString() {
            StringBuffer res = new StringBuffer();
            String argsStr = this.args.toString();
            argsStr = argsStr.substring(1, argsStr.length() - 2);
            res.append(this.oper);
            res.append('(');
            res.append(argsStr);
            res.append(')');
            return res.toString();
        }
    }

    static final class Var
    extends FormulaDecl {
        private final CClass.SClassDecl decl;
        private final List<String> path;

        Var(CClass.SClassDecl decl, List<String> path) {
            this.decl = decl;
            this.path = path;
        }

        @Override
        public Type retType() {
            return this.decl.getSClass().getType();
        }

        @Override
        public Formula resolve(CInstance cInst) {
            return new Formula.Var(cInst.getEffect(this.path), this.decl.getName());
        }

        public String toString() {
            StringBuffer res = new StringBuffer();
            res.append("$" + this.decl.getName() + "$");
            return res.toString();
        }
    }

    static final class Const
    extends FormulaDecl {
        private final Set<Deficiency> val;
        private final Type type;

        Const(Type type, Set<Deficiency> val) {
            this.type = type;
            this.val = val;
        }

        @Override
        public Type retType() {
            return this.type;
        }

        @Override
        public Formula resolve(CInstance cInst) {
            return new Formula.Const(this.val, this.type);
        }

        public String toString() {
            StringBuffer res = new StringBuffer();
            res.append('<');
            res.append(this.type);
            res.append(">{");
            res.append(this.val);
            res.append('}');
            return res.toString();
        }
    }
}

