/*
 * Decompiled with CFR 0.152.
 */
package dk.ange.octave.util;

import java.io.IOException;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TeeWriter
extends Writer {
    private static final Log log = LogFactory.getLog(TeeWriter.class);
    private final Writer[] writers;

    public TeeWriter() {
        this.writers = new Writer[0];
    }

    public TeeWriter(Writer ... writers) {
        this.writers = writers;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        IOException ioe = null;
        for (Writer writer : this.writers) {
            try {
                writer.write(cbuf, off, len);
            }
            catch (IOException e) {
                log.debug((Object)"Exception during write()", (Throwable)e);
                ioe = e;
            }
        }
        if (ioe != null) {
            throw ioe;
        }
    }

    @Override
    public void flush() throws IOException {
        IOException ioe = null;
        for (Writer writer : this.writers) {
            try {
                writer.flush();
            }
            catch (IOException e) {
                log.debug((Object)"Exception during flush()", (Throwable)e);
                ioe = e;
            }
        }
        if (ioe != null) {
            throw ioe;
        }
    }

    @Override
    public void close() throws IOException {
        IOException ioe = null;
        for (Writer writer : this.writers) {
            try {
                writer.close();
            }
            catch (IOException e) {
                log.debug((Object)"Exception during close()", (Throwable)e);
                ioe = e;
            }
        }
        if (ioe != null) {
            throw ioe;
        }
    }
}

