/*
 * Decompiled with CFR 0.152.
 */
package dk.ange.octave.util;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReaderWriterPipeThread
extends Thread {
    private static final Log log = LogFactory.getLog(ReaderWriterPipeThread.class);
    private static final int BUFFERSIZE = 4096;
    private final Reader reader;
    private Writer writer;

    public static ReaderWriterPipeThread instantiate(Reader reader, Writer writer) {
        ReaderWriterPipeThread readerWriterPipeThread = new ReaderWriterPipeThread(reader, writer);
        readerWriterPipeThread.setName(Thread.currentThread().getName() + "-javaoctave-" + ReaderWriterPipeThread.class.getSimpleName());
        readerWriterPipeThread.start();
        return readerWriterPipeThread;
    }

    private ReaderWriterPipeThread(Reader reader, Writer writer) {
        this.reader = reader;
        this.writer = writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        char[] b = new char[4096];
        while (!ReaderWriterPipeThread.interrupted()) {
            int len;
            try {
                len = this.reader.read(b);
            }
            catch (IOException e) {
                log.error((Object)"Error when reading from reader", (Throwable)e);
                throw new RuntimeException(e);
            }
            if (len == -1) break;
            try {
                ReaderWriterPipeThread e = this;
                synchronized (e) {
                    if (this.writer != null) {
                        this.writer.write(b, 0, len);
                        this.writer.flush();
                    }
                }
            }
            catch (IOException e) {
                log.error((Object)"Error when writing to writer", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        log.debug((Object)"ReaderWriterPipeThread finished without error");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWriter(Writer writer) {
        ReaderWriterPipeThread readerWriterPipeThread = this;
        synchronized (readerWriterPipeThread) {
            this.writer = writer;
        }
    }

    public void close() {
        this.interrupt();
        try {
            this.join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

