/*
 * Decompiled with CFR 0.152.
 */
package dk.ange.octave.util;

import java.io.IOException;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NoCloseWriter
extends Writer {
    private static final Log log = LogFactory.getLog(NoCloseWriter.class);
    private Writer writer;

    public NoCloseWriter(Writer writer) {
        this.writer = writer;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (this.writer == null) {
            return;
        }
        this.writer.write(cbuf, off, len);
    }

    @Override
    public void flush() throws IOException {
        if (this.writer == null) {
            return;
        }
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        log.debug((Object)"ignoring close() on a writer");
        if (this.writer == null) {
            return;
        }
        this.writer.flush();
        this.writer = null;
    }

    public void reallyClose() throws IOException {
        log.debug((Object)"reallyClose() a writer");
        this.writer.close();
    }
}

