/*
 * Decompiled with CFR 0.152.
 */
package dk.ange.octave.type.matrix;

import java.util.Arrays;

public abstract class AbstractGenericMatrix<D> {
    protected final int[] size;
    protected D data;

    protected AbstractGenericMatrix(int ... size) {
        this.size = (int[])size.clone();
        this.checkSize();
        this.data = this.newD(AbstractGenericMatrix.product(size));
    }

    protected AbstractGenericMatrix(D data, int ... size) {
        this.size = size;
        this.checkSize();
        this.data = data;
        this.checkDataSize();
    }

    protected AbstractGenericMatrix(AbstractGenericMatrix<D> o) {
        this.size = (int[])o.size.clone();
        this.data = this.newD(AbstractGenericMatrix.product(this.size));
        System.arraycopy(o.data, 0, this.data, 0, AbstractGenericMatrix.product(this.size));
    }

    private void checkSize() throws IllegalArgumentException {
        if (this.size.length == 0) {
            throw new IllegalArgumentException("no size");
        }
        if (this.size.length < 2) {
            throw new IllegalArgumentException("size must have a least 2 dimenstions");
        }
        for (int s : this.size) {
            if (s >= 0) continue;
            throw new IllegalArgumentException("element in size less than zero. =" + s);
        }
    }

    private void checkDataSize() {
        if (AbstractGenericMatrix.product(this.size) > this.dataLength()) {
            StringBuilder text = new StringBuilder();
            text.append("length of data(");
            text.append(this.dataLength());
            text.append(") is smaller than size(");
            text.append("[");
            boolean first = true;
            for (int i : this.size) {
                if (first) {
                    first = false;
                } else {
                    text.append(", ");
                }
                text.append(i);
            }
            text.append("]");
            text.append(")");
            throw new IllegalArgumentException(text.toString());
        }
    }

    protected abstract D newD(int var1);

    protected abstract int dataLength();

    protected abstract void dataFillInit(int var1, int var2);

    protected abstract boolean dataEquals(int var1, D var2);

    private static int product(int ... ns) {
        int p = 1;
        for (int n : ns) {
            p *= n;
        }
        return p;
    }

    public void resizeUp(int ... pos) {
        if (this.size.length != pos.length) {
            throw new UnsupportedOperationException("Change in number of dimensions not supported (" + this.size.length + "!=" + pos.length + ")");
        }
        for (int dim = 0; dim < this.size.length; ++dim) {
            if (pos[dim] <= this.size[dim]) continue;
            this.resizeAlongOneDimension(dim, pos[dim]);
        }
    }

    private void resizeAlongOneDimension(int dim, int newSizeDim) {
        int oldBlockSize = this.size[dim];
        int newBlockSize = newSizeDim;
        for (int d = 0; d < dim; ++d) {
            oldBlockSize *= this.size[d];
            newBlockSize *= this.size[d];
        }
        int oldLength = oldBlockSize;
        int newLength = newBlockSize;
        for (int d = dim + 1; d < this.size.length; ++d) {
            oldLength *= this.size[d];
            newLength *= this.size[d];
        }
        this.size[dim] = newSizeDim;
        if (newLength == 0) {
            return;
        }
        if (this.dataLength() < newLength) {
            D newData = this.newD(newLength * 2);
            int newOffset = 0;
            for (int oldOffset = 0; oldOffset < oldLength; oldOffset += oldBlockSize) {
                System.arraycopy(this.data, oldOffset, newData, newOffset, oldBlockSize);
                newOffset += newBlockSize;
            }
            this.data = newData;
        } else {
            int newOffset = newLength - newBlockSize;
            for (int oldOffset = oldLength - oldBlockSize; oldOffset > 0; oldOffset -= oldBlockSize) {
                System.arraycopy(this.data, oldOffset, this.data, newOffset, oldBlockSize);
                newOffset -= newBlockSize;
            }
            this.dataFillInit(oldBlockSize, newBlockSize);
        }
    }

    public int pos2ind(int ... pos) {
        int idx = 0;
        int factor = 1;
        for (int dim = 0; dim < pos.length; ++dim) {
            if (pos[dim] > this.size[dim]) {
                throw new IndexOutOfBoundsException("pos exceeded dimension for dimension " + dim + " (" + pos[dim] + " > " + this.size[dim] + ")");
            }
            idx += (pos[dim] - 1) * factor;
            factor *= this.size[dim];
        }
        return idx;
    }

    public D getData() {
        return this.data;
    }

    public int[] getSize() {
        return this.size;
    }

    public int size(int i) {
        return this.size[i - 1];
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        result = 31 * result + Arrays.hashCode(this.size);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractGenericMatrix other = (AbstractGenericMatrix)obj;
        if (!Arrays.equals(this.size, other.size)) {
            return false;
        }
        return !(this.data == null ? other.data != null : this.data != other.data && !this.dataEquals(AbstractGenericMatrix.product(this.size), other.data));
    }
}

