/*
 * Decompiled with CFR 0.152.
 */
package dk.ange.octave.type.cast;

import dk.ange.octave.exception.OctaveClassCastException;
import dk.ange.octave.type.OctaveObject;
import dk.ange.octave.type.cast.Caster;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.spi.ServiceRegistry;

public final class Cast {
    private static Map<ClassPair<?, ?>, Caster<?, ?>> casterMap;

    private Cast() {
        throw new UnsupportedOperationException("Do not instantiate");
    }

    private static synchronized void initIfNecessary() {
        if (casterMap == null) {
            casterMap = new HashMap();
            Iterator<Caster> sp = ServiceRegistry.lookupProviders(Caster.class);
            while (sp.hasNext()) {
                Cast.register(sp.next());
            }
        }
    }

    private static <F, T> void register(Caster<F, T> caster) {
        ClassPair<F, T> cp = new ClassPair<F, T>(caster.from(), caster.to());
        if (casterMap.containsKey(cp)) {
            throw new RuntimeException("casterMap.containsKey(cp)");
        }
        casterMap.put(cp, caster);
    }

    public static <F extends OctaveObject, T extends OctaveObject> T cast(Class<T> toClass, F from) {
        if (from == null) {
            return null;
        }
        if (toClass.isInstance(from)) {
            return (T)((OctaveObject)toClass.cast(from));
        }
        ClassPair<F, T> cp = new ClassPair<F, T>(Cast.unsafeGetClass(from), toClass);
        Caster<F, T> caster = Cast.casterMapGet(cp);
        if (caster == null) {
            throw new OctaveClassCastException(null, from, toClass);
        }
        return (T)((OctaveObject)caster.cast(from));
    }

    private static <F> Class<F> unsafeGetClass(F from) {
        return from.getClass();
    }

    private static <F extends OctaveObject, T extends OctaveObject> Caster<F, T> casterMapGet(ClassPair<F, T> cp) {
        Cast.initIfNecessary();
        if (!casterMap.containsKey(cp)) {
            return null;
        }
        Caster<?, ?> caster = casterMap.get(cp);
        if (!caster.from().equals(cp.from)) {
            throw new RuntimeException("!caster.from().equals(cp.from)");
        }
        if (!caster.to().equals(cp.to)) {
            throw new RuntimeException("!caster.to().equals(cp.to)");
        }
        return caster;
    }

    private static class ClassPair<F, T> {
        Class<F> from;
        Class<T> to;

        ClassPair(Class<F> from, Class<T> to) {
            this.from = from;
            this.to = to;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.from == null ? 0 : this.from.hashCode());
            result = 31 * result + (this.to == null ? 0 : this.to.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ClassPair other = (ClassPair)obj;
            if (this.from == null ? other.from != null : !this.from.equals(other.from)) {
                return false;
            }
            return !(this.to == null ? other.to != null : !this.to.equals(other.to));
        }
    }
}

