/*
 * Decompiled with CFR 0.152.
 */
package dk.ange.octave.type;

import dk.ange.octave.type.OctaveObject;
import java.util.Arrays;

public class OctaveSparseBoolean
implements OctaveObject {
    private final int rows;
    private final int columns;
    private int nnz;
    private final int[] rowIndexes;
    private final int[] columnIndexes;
    private final boolean[] data;

    private OctaveSparseBoolean(int rows, int columns, int nnz, int[] rowIndexes, int[] columnIndexes, boolean[] data) {
        this.rows = rows;
        this.columns = columns;
        this.nnz = nnz;
        this.rowIndexes = rowIndexes;
        this.columnIndexes = columnIndexes;
        this.data = data;
    }

    public OctaveSparseBoolean(int rows, int columns, int nnz) {
        this(rows, columns, 0, new int[nnz], new int[nnz], new boolean[nnz]);
    }

    @Override
    public OctaveSparseBoolean shallowCopy() {
        return new OctaveSparseBoolean(this.rows, this.columns, this.nnz, this.rowIndexes, this.columnIndexes, this.data);
    }

    public void set(boolean value, int row, int column) {
        this.data[this.nnz] = value;
        this.rowIndexes[this.nnz] = row;
        this.columnIndexes[this.nnz] = column;
        ++this.nnz;
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.columns;
    }

    public int getNnz() {
        return this.nnz;
    }

    public int[] getRowIndexes() {
        return this.rowIndexes;
    }

    public int[] getColumnIndexes() {
        return this.columnIndexes;
    }

    public boolean[] getData() {
        return this.data;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.columnIndexes);
        result = 31 * result + this.columns;
        result = 31 * result + Arrays.hashCode(this.data);
        result = 31 * result + this.nnz;
        result = 31 * result + Arrays.hashCode(this.rowIndexes);
        result = 31 * result + this.rows;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OctaveSparseBoolean other = (OctaveSparseBoolean)obj;
        if (!Arrays.equals(this.columnIndexes, other.columnIndexes)) {
            return false;
        }
        if (this.columns != other.columns) {
            return false;
        }
        if (!Arrays.equals(this.data, other.data)) {
            return false;
        }
        if (this.nnz != other.nnz) {
            return false;
        }
        if (!Arrays.equals(this.rowIndexes, other.rowIndexes)) {
            return false;
        }
        return this.rows == other.rows;
    }
}

