/*
 * Decompiled with CFR 0.152.
 */
package dk.ange.octave.type;

import dk.ange.octave.type.OctaveObject;
import dk.ange.octave.type.matrix.DoubleMatrix;

public class OctaveComplex
implements OctaveObject {
    private final DoubleMatrix real;
    private final DoubleMatrix imag;

    public OctaveComplex(int ... size) {
        this.real = new DoubleMatrix(size);
        this.imag = new DoubleMatrix(size);
    }

    public OctaveComplex(OctaveComplex o) {
        this.real = new DoubleMatrix(o.real);
        this.imag = new DoubleMatrix(o.imag);
    }

    public OctaveComplex(double[] realData, int ... size) {
        this.real = new DoubleMatrix(realData, size);
        this.imag = new DoubleMatrix(size);
    }

    public int size(int i) {
        return this.real.size(i);
    }

    public int pos2ind(int ... pos) {
        return this.real.pos2ind(pos);
    }

    public void setReal(double value, int ... pos) {
        this.real.set(value, pos);
        this.imag.resizeUp(pos);
    }

    public double getReal(int ... pos) {
        return this.real.get(pos);
    }

    public double[] getReal() {
        return (double[])this.real.getData();
    }

    public void setImag(double value, int ... pos) {
        this.real.resizeUp(pos);
        this.imag.set(value, pos);
    }

    public double getImag(int ... pos) {
        return this.imag.get(pos);
    }

    public double[] getImag() {
        return (double[])this.imag.getData();
    }

    @Override
    public OctaveComplex shallowCopy() {
        return new OctaveComplex(this);
    }
}

