/*
 * Decompiled with CFR 0.152.
 */
package dk.ange.octave.io.spi;

import dk.ange.octave.type.OctaveObject;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.spi.ServiceRegistry;

public abstract class OctaveDataWriter<T extends OctaveObject> {
    private static Map<Class<? extends OctaveObject>, OctaveDataWriter<?>> writers;

    public static <T extends OctaveObject> OctaveDataWriter<T> getOctaveDataWriter(T example) {
        OctaveDataWriter.initIfNecessary();
        return writers.get(example.getClass());
    }

    private static synchronized void initIfNecessary() {
        if (writers == null) {
            writers = new HashMap();
            Iterator<OctaveDataWriter> sp = ServiceRegistry.lookupProviders(OctaveDataWriter.class);
            while (sp.hasNext()) {
                OctaveDataWriter odw = sp.next();
                writers.put(odw.javaType(), odw);
            }
        }
    }

    public abstract Class<T> javaType();

    public abstract void write(Writer var1, T var2) throws IOException;
}

