/*
 * Decompiled with CFR 0.152.
 */
package dk.ange.octave.io.spi;

import dk.ange.octave.type.OctaveObject;
import java.io.BufferedReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.spi.ServiceRegistry;

public abstract class OctaveDataReader {
    private static Map<String, OctaveDataReader> readers = null;

    public static OctaveDataReader getOctaveDataReader(String type) {
        OctaveDataReader.initIfNecessary();
        return readers.get(type);
    }

    private static synchronized void initIfNecessary() {
        if (readers != null) {
            return;
        }
        readers = new HashMap<String, OctaveDataReader>();
        Iterator<OctaveDataReader> sp = ServiceRegistry.lookupProviders(OctaveDataReader.class);
        while (sp.hasNext()) {
            OctaveDataReader odr = sp.next();
            readers.put(odr.octaveType(), odr);
        }
    }

    public abstract String octaveType();

    public abstract OctaveObject read(BufferedReader var1);
}

