/*
 * Decompiled with CFR 0.152.
 */
package dk.ange.octave.io.impl;

import dk.ange.octave.exception.OctaveParseException;
import dk.ange.octave.io.OctaveIO;
import dk.ange.octave.io.spi.OctaveDataReader;
import dk.ange.octave.type.OctaveInt;
import java.io.BufferedReader;

public final class Uint8MatrixReader
extends OctaveDataReader {
    @Override
    public String octaveType() {
        return "uint8 matrix";
    }

    @Override
    public OctaveInt read(BufferedReader reader) {
        String line = OctaveIO.readerReadLine(reader);
        return this.readVectorizedMatrix(reader, line);
    }

    private OctaveInt readVectorizedMatrix(BufferedReader reader, String ndimsLine) {
        String NDIMS = "# ndims: ";
        String line = ndimsLine;
        if (!line.startsWith("# ndims: ")) {
            throw new OctaveParseException("Expected '# ndims: ', but got '" + line + "'");
        }
        int ndims = Integer.parseInt(line.substring("# ndims: ".length()));
        line = OctaveIO.readerReadLine(reader);
        String[] split = line.substring(1).split(" ");
        if (split.length != ndims) {
            throw new OctaveParseException("Expected " + ndims + " dimesion, but got " + split.length + " (line was '" + line + "')");
        }
        int[] size = new int[split.length];
        for (int dim = 0; dim < split.length; ++dim) {
            size[dim] = Integer.parseInt(split[dim]);
        }
        int[] data = new int[Uint8MatrixReader.product(size)];
        for (int idx = 0; idx < data.length; ++idx) {
            line = OctaveIO.readerReadLine(reader);
            data[idx] = line.codePointAt(1);
        }
        return new OctaveInt(data, size);
    }

    private static int product(int ... ns) {
        int p = 1;
        for (int n : ns) {
            p *= n;
        }
        return p;
    }
}

