/*
 * Decompiled with CFR 0.152.
 */
package dk.ange.octave.io.impl;

import dk.ange.octave.io.OctaveIO;
import dk.ange.octave.io.spi.OctaveDataWriter;
import dk.ange.octave.type.OctaveObject;
import dk.ange.octave.type.OctaveStruct;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;

public final class StructWriter
extends OctaveDataWriter<OctaveStruct> {
    @Override
    public Class<OctaveStruct> javaType() {
        return OctaveStruct.class;
    }

    @Override
    public void write(Writer writer, OctaveStruct octaveStruct) throws IOException {
        Map<String, OctaveObject> data = octaveStruct.getData();
        writer.write("# type: struct\n# length: " + data.size() + "\n");
        for (Map.Entry<String, OctaveObject> entry : data.entrySet()) {
            String subname = entry.getKey();
            OctaveObject value = entry.getValue();
            writer.write("# name: " + subname + "\n");
            writer.write("# type: cell\n");
            writer.write("# rows: 1\n");
            writer.write("# columns: 1\n");
            OctaveIO.write(writer, "<cell-element>", value);
            writer.write("\n");
        }
    }
}

