/*
 * Decompiled with CFR 0.152.
 */
package dk.ange.octave.io.impl;

import dk.ange.octave.exception.OctaveParseException;
import dk.ange.octave.io.OctaveIO;
import dk.ange.octave.io.impl.CellReader;
import dk.ange.octave.io.spi.OctaveDataReader;
import dk.ange.octave.type.OctaveCell;
import dk.ange.octave.type.OctaveObject;
import dk.ange.octave.type.OctaveStruct;
import java.io.BufferedReader;
import java.util.Arrays;
import java.util.HashMap;

public class StructReader
extends OctaveDataReader {
    private static final CellReader cellReader = new CellReader();

    @Override
    public String octaveType() {
        return "struct";
    }

    @Override
    public OctaveStruct read(BufferedReader reader) {
        String line = OctaveIO.readerReadLine(reader);
        if (line != null && line.startsWith("# ndims:")) {
            if (!line.equals("# ndims: 2")) {
                throw new OctaveParseException("JavaOctave does not support matrix structs, read=" + line);
            }
            line = OctaveIO.readerReadLine(reader);
            if (!line.equals(" 1 1")) {
                throw new OctaveParseException("JavaOctave does not support matrix structs, read=" + line);
            }
            line = OctaveIO.readerReadLine(reader);
        }
        String LENGTH = "# length: ";
        if (line == null || !line.startsWith("# length: ")) {
            throw new OctaveParseException("Expected '# length: ' got '" + line + "'");
        }
        int length = Integer.valueOf(line.substring("# length: ".length()));
        HashMap<String, OctaveObject> data = new HashMap<String, OctaveObject>();
        for (int i = 0; i < length; ++i) {
            String NAME = "# name: ";
            while ("".equals(line = OctaveIO.readerReadLine(reader))) {
            }
            if (!line.startsWith("# name: ")) {
                throw new OctaveParseException("Expected '# name: ' got '" + line + "'");
            }
            String subname = line.substring("# name: ".length());
            String CELL = "# type: cell";
            line = OctaveIO.readerReadLine(reader);
            if (!line.equals("# type: cell")) {
                throw new OctaveParseException("Expected '# type: cell' got '" + line + "'");
            }
            OctaveCell cell = cellReader.read(reader);
            if (cell.size(1) != 1 || cell.size(2) != 1) {
                throw new OctaveParseException("JavaOctave does not support matrix structs, size=" + Arrays.toString(cell.getSize()));
            }
            OctaveObject value = cell.get(1, 1);
            data.put(subname, value);
        }
        return new OctaveStruct(data);
    }
}

