/*
 * Decompiled with CFR 0.152.
 */
package dk.ange.octave.io.impl;

import dk.ange.octave.io.spi.OctaveDataWriter;
import dk.ange.octave.type.OctaveSparseBoolean;
import java.io.IOException;
import java.io.Writer;

public final class SparseBooleanWriter
extends OctaveDataWriter<OctaveSparseBoolean> {
    @Override
    public Class<OctaveSparseBoolean> javaType() {
        return OctaveSparseBoolean.class;
    }

    @Override
    public void write(Writer writer, OctaveSparseBoolean octaveSparseBoolean) throws IOException {
        int nnz = octaveSparseBoolean.getNnz();
        writer.write("# type: sparse bool matrix\n");
        writer.write("# nnz: " + nnz + "\n");
        writer.write("# rows: " + octaveSparseBoolean.getRows() + "\n");
        writer.write("# columns: " + octaveSparseBoolean.getColumns() + "\n");
        int[] rowIndexes = octaveSparseBoolean.getRowIndexes();
        int[] columnIndexes = octaveSparseBoolean.getColumnIndexes();
        boolean[] data = octaveSparseBoolean.getData();
        for (int n = 0; n < nnz; ++n) {
            writer.write(rowIndexes[n] + " " + columnIndexes[n] + " " + (data[n] ? "1" : "0") + "\n");
        }
    }
}

