/*
 * Decompiled with CFR 0.152.
 */
package dk.ange.octave.io.impl;

import dk.ange.octave.exception.OctaveParseException;
import dk.ange.octave.io.OctaveIO;
import dk.ange.octave.io.impl.BooleanReader;
import dk.ange.octave.io.spi.OctaveDataReader;
import dk.ange.octave.type.OctaveSparseBoolean;
import java.io.BufferedReader;

public final class SparseBooleanReader
extends OctaveDataReader {
    @Override
    public String octaveType() {
        return "sparse bool matrix";
    }

    @Override
    public OctaveSparseBoolean read(BufferedReader reader) {
        int nnz = this.parseHeader("# nnz: ", OctaveIO.readerReadLine(reader));
        int rows = this.parseHeader("# rows: ", OctaveIO.readerReadLine(reader));
        int columns = this.parseHeader("# columns: ", OctaveIO.readerReadLine(reader));
        OctaveSparseBoolean sparse = new OctaveSparseBoolean(rows, columns, nnz);
        for (int n = 0; n < nnz; ++n) {
            String line = OctaveIO.readerReadLine(reader);
            String[] split = line.split(" ");
            if (split.length != 3) {
                throw new OctaveParseException("split.length != 3");
            }
            try {
                int row = Integer.parseInt(split[0]);
                int column = Integer.parseInt(split[1]);
                boolean value = BooleanReader.parseBoolean(split[2]);
                sparse.set(value, row, column);
                continue;
            }
            catch (NumberFormatException e) {
                throw new OctaveParseException(e);
            }
        }
        return sparse;
    }

    private int parseHeader(String prefix, String line) {
        if (line == null || !line.startsWith(prefix)) {
            throw new OctaveParseException("Expected a line that should start with '" + prefix + "', got '" + line + "'");
        }
        try {
            return Integer.parseInt(line.substring(prefix.length()));
        }
        catch (NumberFormatException e) {
            throw new OctaveParseException(e);
        }
    }
}

