/*
 * Decompiled with CFR 0.152.
 */
package dk.ange.octave.io.impl;

import dk.ange.octave.exception.OctaveParseException;
import dk.ange.octave.io.OctaveIO;
import dk.ange.octave.io.spi.OctaveDataReader;
import dk.ange.octave.type.OctaveObject;
import dk.ange.octave.type.OctaveStruct;
import java.io.BufferedReader;
import java.util.HashMap;

public final class ScalarStructReader
extends OctaveDataReader {
    @Override
    public String octaveType() {
        return "scalar struct";
    }

    @Override
    public OctaveObject read(BufferedReader reader) {
        String line = OctaveIO.readerReadLine(reader);
        if (!line.equals("# ndims: 2")) {
            throw new OctaveParseException("JavaOctave does not support matrix structs, read=" + line);
        }
        line = OctaveIO.readerReadLine(reader);
        if (!line.equals(" 1 1")) {
            throw new OctaveParseException("JavaOctave does not support matrix structs, read=" + line);
        }
        line = OctaveIO.readerReadLine(reader);
        String LENGTH = "# length: ";
        if (line == null || !line.startsWith("# length: ")) {
            throw new OctaveParseException("Expected '# length: ' got '" + line + "'");
        }
        int length = Integer.valueOf(line.substring("# length: ".length()));
        HashMap<String, OctaveObject> data = new HashMap<String, OctaveObject>();
        for (int i = 0; i < length; ++i) {
            String NAME = "# name: ";
            while ("".equals(line = OctaveIO.readerReadLine(reader))) {
            }
            if (!line.startsWith("# name: ")) {
                throw new OctaveParseException("Expected '# name: ' got '" + line + "'");
            }
            String subname = line.substring("# name: ".length());
            OctaveObject value = OctaveIO.read(reader);
            data.put(subname, value);
        }
        return new OctaveStruct(data);
    }
}

