/*
 * Decompiled with CFR 0.152.
 */
package dk.ange.octave.io.impl;

import dk.ange.octave.exception.OctaveParseException;
import dk.ange.octave.io.OctaveIO;
import dk.ange.octave.io.spi.OctaveDataReader;
import dk.ange.octave.type.OctaveString;
import java.io.BufferedReader;

public class OctaveStringReader
extends OctaveDataReader {
    @Override
    public String octaveType() {
        return "string";
    }

    @Override
    public OctaveString read(BufferedReader reader) {
        String elements = OctaveIO.readerReadLine(reader);
        StringBuilder builder = new StringBuilder();
        if (!elements.equals("# elements: 0")) {
            if (elements.equals("# elements: 1")) {
                String lengthString = OctaveIO.readerReadLine(reader);
                if (!lengthString.startsWith("# length: ")) {
                    throw new OctaveParseException("Parse error in String, line='" + lengthString + "'");
                }
                int length = Integer.parseInt(lengthString.substring(10));
                boolean first = true;
                while (builder.length() < length) {
                    if (!first) {
                        builder.append('\n');
                    }
                    builder.append(OctaveIO.readerReadLine(reader));
                    first = false;
                }
                if (builder.length() != length) {
                    throw new OctaveParseException("Unexpected length of string read. expected=" + length + ", actual=" + builder.length());
                }
            } else {
                throw new OctaveParseException("Expected elements to be 0 or 1, '" + elements + "'");
            }
        }
        return new OctaveString(builder.toString());
    }
}

