/*
 * Decompiled with CFR 0.152.
 */
package dk.ange.octave.io.impl;

import dk.ange.octave.io.spi.OctaveDataWriter;
import dk.ange.octave.type.OctaveDouble;
import java.io.IOException;
import java.io.Writer;

public final class MatrixWriter
extends OctaveDataWriter<OctaveDouble> {
    @Override
    public Class<OctaveDouble> javaType() {
        return OctaveDouble.class;
    }

    @Override
    public void write(Writer writer, OctaveDouble octaveMatrix) throws IOException {
        if (octaveMatrix.getSize().length <= 2) {
            if (octaveMatrix.getSize().length == 2 && octaveMatrix.size(1) == 1 && octaveMatrix.size(2) == 1) {
                writer.write("# type: scalar\n");
                writer.write(octaveMatrix.get(1, 1) + "\n");
            } else {
                writer.write("# type: matrix\n");
                this.saveData2d(writer, octaveMatrix);
            }
        } else {
            writer.write("# type: matrix\n");
            this.saveDataVectorized(writer, octaveMatrix);
        }
    }

    private void saveData2d(Writer writer, OctaveDouble octaveMatrix) throws IOException {
        int[] size = octaveMatrix.getSize();
        double[] data = (double[])octaveMatrix.getData();
        int nrows = size[0];
        int ncols = size.length > 1 ? size[1] : 1;
        writer.write("# rows: " + nrows + "\n# columns: " + ncols + "\n");
        for (int row = 0; row < nrows; ++row) {
            for (int col = 0; col < ncols; ++col) {
                writer.write(" " + data[row + col * nrows]);
            }
            writer.write(10);
        }
    }

    private void saveDataVectorized(Writer writer, OctaveDouble octaveMatrix) throws IOException {
        int[] size = octaveMatrix.getSize();
        double[] data = (double[])octaveMatrix.getData();
        writer.write("# ndims: " + size.length + "\n");
        for (int sdim : size) {
            writer.write(" " + sdim);
        }
        for (double d : data) {
            writer.write("\n " + d);
        }
        writer.write("\n");
    }
}

