/*
 * Decompiled with CFR 0.152.
 */
package dk.ange.octave.io.impl;

import dk.ange.octave.exception.OctaveParseException;
import dk.ange.octave.io.OctaveIO;
import dk.ange.octave.io.impl.ScalarReader;
import dk.ange.octave.io.spi.OctaveDataReader;
import dk.ange.octave.type.OctaveDouble;
import java.io.BufferedReader;

public final class MatrixReader
extends OctaveDataReader {
    @Override
    public String octaveType() {
        return "matrix";
    }

    @Override
    public OctaveDouble read(BufferedReader reader) {
        String line = OctaveIO.readerReadLine(reader);
        if (line.startsWith("# rows: ")) {
            return this.read2dmatrix(reader, line);
        }
        if (line.startsWith("# ndims: ")) {
            return this.readVectorizedMatrix(reader, line);
        }
        throw new OctaveParseException("Expected <# rows: > or <# ndims: >, but got <" + line + ">");
    }

    private OctaveDouble readVectorizedMatrix(BufferedReader reader, String ndimsLine) {
        String NDIMS = "# ndims: ";
        String line = ndimsLine;
        if (!line.startsWith("# ndims: ")) {
            throw new OctaveParseException("Expected <# ndims: >, but got <" + line + ">");
        }
        int ndims = Integer.parseInt(line.substring("# ndims: ".length()));
        line = OctaveIO.readerReadLine(reader);
        String[] split = line.substring(1).split(" ");
        if (split.length != ndims) {
            throw new OctaveParseException("Expected " + ndims + " dimesion, but got " + split.length + " (line was <" + line + ">)");
        }
        int[] size = new int[split.length];
        for (int dim = 0; dim < split.length; ++dim) {
            size[dim] = Integer.parseInt(split[dim]);
        }
        double[] data = new double[MatrixReader.product(size)];
        for (int idx = 0; idx < data.length; ++idx) {
            line = OctaveIO.readerReadLine(reader);
            data[idx] = ScalarReader.parseDouble(line);
        }
        return new OctaveDouble(data, size);
    }

    private OctaveDouble read2dmatrix(BufferedReader reader, String rowsLine) {
        String line = rowsLine;
        if (!line.startsWith("# rows: ")) {
            throw new OctaveParseException("Expected <# rows: > got <" + line + ">");
        }
        int rows = Integer.valueOf(line.substring(8));
        line = OctaveIO.readerReadLine(reader);
        if (!line.startsWith("# columns: ")) {
            throw new OctaveParseException("Expected <# columns: > got <" + line + ">");
        }
        int columns = Integer.valueOf(line.substring(11));
        int[] size = new int[]{rows, columns};
        double[] data = new double[rows * columns];
        for (int r = 1; r <= rows; ++r) {
            line = OctaveIO.readerReadLine(reader);
            String[] split = line.split(" ");
            if (split.length != columns + 1) {
                throw new OctaveParseException("Error in matrix-format: '" + line + "'");
            }
            for (int c = 1; c < split.length; ++c) {
                data[r - 1 + (c - 1) * rows] = ScalarReader.parseDouble(split[c]);
            }
        }
        return new OctaveDouble(data, size);
    }

    private static int product(int ... ns) {
        int p = 1;
        for (int n : ns) {
            p *= n;
        }
        return p;
    }
}

