/*
 * Decompiled with CFR 0.152.
 */
package dk.ange.octave.io.impl;

import dk.ange.octave.exception.OctaveParseException;
import dk.ange.octave.io.OctaveIO;
import dk.ange.octave.io.impl.ScalarReader;
import dk.ange.octave.io.spi.OctaveDataReader;
import dk.ange.octave.type.OctaveComplex;
import java.io.BufferedReader;

public final class ComplexMatrixReader
extends OctaveDataReader {
    @Override
    public String octaveType() {
        return "complex matrix";
    }

    @Override
    public OctaveComplex read(BufferedReader reader) {
        int rows = this.parseRows(reader);
        int columns = this.parseColumns(reader);
        OctaveComplex complex = new OctaveComplex(rows, columns);
        for (int r = 1; r <= rows; ++r) {
            String line = OctaveIO.readerReadLine(reader);
            String[] split = line.split(" ");
            if (split.length != columns + 1) {
                throw new OctaveParseException("Error in complex matrix-format: '" + line + "'");
            }
            int c = 1;
            while (c < split.length) {
                int commaIndex = split[c].indexOf(44);
                double real = ScalarReader.parseDouble(split[c].substring(1, commaIndex));
                double imag = ScalarReader.parseDouble(split[c].substring(commaIndex + 1, split[c].length() - 1));
                complex.setReal(real, r, c);
                complex.setImag(imag, r, c++);
            }
        }
        return complex;
    }

    public int parseRows(BufferedReader reader) {
        String line = OctaveIO.readerReadLine(reader);
        if (!line.startsWith("# rows: ")) {
            throw new OctaveParseException("Expected <# rows: > got <" + line + ">");
        }
        return Integer.valueOf(line.substring(8));
    }

    public int parseColumns(BufferedReader reader) {
        String line = OctaveIO.readerReadLine(reader);
        if (!line.startsWith("# columns: ")) {
            throw new OctaveParseException("Expected <# columns: > got <" + line + ">");
        }
        return Integer.valueOf(line.substring(11));
    }
}

