/*
 * Decompiled with CFR 0.152.
 */
package dk.ange.octave.io.impl;

import dk.ange.octave.io.OctaveIO;
import dk.ange.octave.io.spi.OctaveDataWriter;
import dk.ange.octave.type.OctaveCell;
import dk.ange.octave.type.OctaveObject;
import java.io.IOException;
import java.io.Writer;

public final class CellWriter
extends OctaveDataWriter<OctaveCell> {
    @Override
    public Class<OctaveCell> javaType() {
        return OctaveCell.class;
    }

    @Override
    public void write(Writer writer, OctaveCell octaveCell) throws IOException {
        int rows = octaveCell.size(1);
        int columns = octaveCell.size(2);
        writer.write("# type: cell\n");
        writer.write("# rows: " + rows + "\n");
        writer.write("# columns: " + columns + "\n");
        for (int c = 1; c <= columns; ++c) {
            int r = 1;
            while (r <= rows) {
                OctaveObject value = octaveCell.get(r++, c);
                OctaveIO.write(writer, "<cell-element>", value);
            }
            writer.write("\n");
        }
    }
}

