/*
 * Decompiled with CFR 0.152.
 */
package dk.ange.octave.io.impl;

import dk.ange.octave.exception.OctaveParseException;
import dk.ange.octave.io.OctaveIO;
import dk.ange.octave.io.spi.OctaveDataReader;
import dk.ange.octave.type.OctaveCell;
import dk.ange.octave.type.OctaveObject;
import java.io.BufferedReader;

public final class CellReader
extends OctaveDataReader {
    @Override
    public String octaveType() {
        return "cell";
    }

    @Override
    public OctaveCell read(BufferedReader reader) {
        String token;
        String line = OctaveIO.readerReadLine(reader);
        if (!line.startsWith(token = "# rows: ")) {
            throw new OctaveParseException("Expected <" + token + ">, but got <" + line + ">");
        }
        int nrows = Integer.parseInt(line.substring(token.length()));
        line = OctaveIO.readerReadLine(reader);
        if (!line.startsWith(token = "# columns: ")) {
            throw new OctaveParseException("Expected <" + token + ">, but got <" + line + ">");
        }
        int ncols = Integer.parseInt(line.substring(token.length()));
        OctaveCell octaveCell = new OctaveCell(nrows, ncols);
        for (int col = 1; col <= ncols; ++col) {
            int row = 1;
            while (row <= nrows) {
                while ("".equals(line = OctaveIO.readerReadLine(reader))) {
                }
                token = "# name: <cell-element>";
                if (!line.equals(token)) {
                    throw new OctaveParseException("Expected <" + token + ">, but got <" + line + ">");
                }
                OctaveObject octaveType = OctaveIO.read(reader);
                octaveCell.set(octaveType, row++, col);
            }
            line = OctaveIO.readerReadLine(reader);
            token = "";
            if (line != null && line.equals(token)) continue;
            throw new OctaveParseException("Expected <" + token + ">, but got <" + line + ">");
        }
        return octaveCell;
    }
}

