/*
 * Decompiled with CFR 0.152.
 */
package dk.ange.octave.io.impl;

import dk.ange.octave.io.spi.OctaveDataWriter;
import dk.ange.octave.type.OctaveBoolean;
import java.io.IOException;
import java.io.Writer;

public final class BooleanWriter
extends OctaveDataWriter<OctaveBoolean> {
    @Override
    public Class<OctaveBoolean> javaType() {
        return OctaveBoolean.class;
    }

    @Override
    public void write(Writer writer, OctaveBoolean octaveBoolean) throws IOException {
        writer.write("# type: bool matrix\n");
        if (octaveBoolean.getSize().length > 2) {
            this.saveDataVectorized(writer, octaveBoolean);
        } else {
            this.saveData2d(writer, octaveBoolean);
        }
    }

    private void saveData2d(Writer writer, OctaveBoolean octaveBoolean) throws IOException {
        int[] size = octaveBoolean.getSize();
        boolean[] data = (boolean[])octaveBoolean.getData();
        int nrows = size[0];
        int ncols = size.length > 1 ? size[1] : 1;
        writer.write("# rows: " + nrows + "\n# columns: " + ncols + "\n");
        for (int row = 0; row < nrows; ++row) {
            for (int col = 0; col < ncols; ++col) {
                writer.write(" " + (data[row + col * nrows] ? "1" : "0"));
            }
            writer.write(10);
        }
    }

    private void saveDataVectorized(Writer writer, OctaveBoolean octaveMatrix) throws IOException {
        int[] size = octaveMatrix.getSize();
        boolean[] data = (boolean[])octaveMatrix.getData();
        writer.write("# ndims: " + size.length + "\n");
        for (int sdim : size) {
            writer.write(" " + sdim);
        }
        for (boolean b : data) {
            writer.write("\n " + (b ? "1" : "0"));
        }
        writer.write("\n");
    }
}

