/*
 * Decompiled with CFR 0.152.
 */
package dk.ange.octave.io.impl;

import dk.ange.octave.exception.OctaveParseException;
import dk.ange.octave.io.OctaveIO;
import dk.ange.octave.io.spi.OctaveDataReader;
import dk.ange.octave.type.OctaveBoolean;
import java.io.BufferedReader;

public final class BooleanReader
extends OctaveDataReader {
    @Override
    public String octaveType() {
        return "bool matrix";
    }

    @Override
    public OctaveBoolean read(BufferedReader reader) {
        String line = OctaveIO.readerReadLine(reader);
        if (line.startsWith("# rows: ")) {
            return this.read2dmatrix(reader, line);
        }
        if (line.startsWith("# ndims: ")) {
            return this.readVectorizedMatrix(reader, line);
        }
        throw new OctaveParseException("Expected '# rows: ' or '# ndims: ', but got '" + line + "'");
    }

    private OctaveBoolean readVectorizedMatrix(BufferedReader reader, String ndimsLine) {
        String NDIMS = "# ndims: ";
        String line = ndimsLine;
        if (!line.startsWith("# ndims: ")) {
            throw new OctaveParseException("Expected '# ndims: ', but got '" + line + "'");
        }
        int ndims = Integer.parseInt(line.substring("# ndims: ".length()));
        line = OctaveIO.readerReadLine(reader);
        String[] split = line.substring(1).split(" ");
        if (split.length != ndims) {
            throw new OctaveParseException("Expected " + ndims + " dimesion, but got " + split.length + " (line was '" + line + "')");
        }
        int[] size = new int[split.length];
        for (int dim = 0; dim < split.length; ++dim) {
            size[dim] = Integer.parseInt(split[dim]);
        }
        boolean[] data = new boolean[BooleanReader.product(size)];
        for (int idx = 0; idx < data.length; ++idx) {
            line = OctaveIO.readerReadLine(reader);
            data[idx] = BooleanReader.parseBoolean(line.trim());
        }
        return new OctaveBoolean(data, size);
    }

    static boolean parseBoolean(String line) {
        if ("0".equals(line)) {
            return false;
        }
        if ("1".equals(line)) {
            return true;
        }
        throw new OctaveParseException("Invalid input, '" + line + "'");
    }

    private OctaveBoolean read2dmatrix(BufferedReader reader, String rowsLine) {
        String line = rowsLine;
        if (!line.startsWith("# rows: ")) {
            throw new OctaveParseException("Expected '# rows: ' got '" + line + "'");
        }
        int rows = Integer.valueOf(line.substring(8));
        line = OctaveIO.readerReadLine(reader);
        if (!line.startsWith("# columns: ")) {
            throw new OctaveParseException("Expected '# columns: ' got '" + line + "'");
        }
        int columns = Integer.valueOf(line.substring(11));
        int[] size = new int[]{rows, columns};
        boolean[] data = new boolean[rows * columns];
        for (int r = 1; r <= rows; ++r) {
            line = OctaveIO.readerReadLine(reader);
            String[] split = line.split(" ");
            if (split.length != columns + 1) {
                throw new OctaveParseException("Error in matrix-format: '" + line + "'");
            }
            for (int c = 1; c < split.length; ++c) {
                data[r - 1 + (c - 1) * rows] = BooleanReader.parseBoolean(split[c]);
            }
        }
        return new OctaveBoolean(data, size);
    }

    private static int product(int ... ns) {
        int p = 1;
        for (int n : ns) {
            p *= n;
        }
        return p;
    }
}

