/*
 * Decompiled with CFR 0.152.
 */
package dk.ange.octave.io;

import dk.ange.octave.exception.OctaveIOException;
import dk.ange.octave.exception.OctaveParseException;
import dk.ange.octave.exec.OctaveExec;
import dk.ange.octave.exec.ReaderWriteFunctor;
import dk.ange.octave.exec.WriterReadFunctor;
import dk.ange.octave.io.DataReadFunctor;
import dk.ange.octave.io.DataWriteFunctor;
import dk.ange.octave.io.spi.OctaveDataReader;
import dk.ange.octave.io.spi.OctaveDataWriter;
import dk.ange.octave.type.OctaveObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.Map;

public final class OctaveIO {
    private final OctaveExec octaveExec;

    public OctaveIO(OctaveExec octaveExec) {
        this.octaveExec = octaveExec;
    }

    public void set(Map<String, OctaveObject> values) {
        StringWriter outputWriter = new StringWriter();
        this.octaveExec.eval(new DataWriteFunctor(values), new WriterReadFunctor(outputWriter));
        String output = outputWriter.toString();
        if (output.length() != 0) {
            throw new IllegalStateException("Unexpected output, " + output);
        }
    }

    public OctaveObject get(String name) {
        if (!this.checkIfVarExists(name)) {
            return null;
        }
        ReaderWriteFunctor writeFunctor = new ReaderWriteFunctor(new StringReader("save -text - " + name));
        DataReadFunctor readFunctor = new DataReadFunctor(name);
        this.octaveExec.eval(writeFunctor, readFunctor);
        return readFunctor.getData();
    }

    private boolean checkIfVarExists(String name) {
        StringWriter existResult = new StringWriter();
        this.octaveExec.eval(new ReaderWriteFunctor(new StringReader("printf(\"%d\", exist(\"" + name + "\",\"var\"));")), new WriterReadFunctor(existResult));
        String s = existResult.toString();
        if ("1".equals(s)) {
            return true;
        }
        if ("0".equals(s)) {
            return false;
        }
        throw new OctaveParseException("Unexpected output '" + s + "'");
    }

    public static String readerReadLine(BufferedReader reader) {
        try {
            return reader.readLine();
        }
        catch (IOException e) {
            throw new OctaveIOException(e);
        }
    }

    public static OctaveObject read(BufferedReader reader) {
        String line = OctaveIO.readerReadLine(reader);
        String TYPE = "# type: ";
        if (line == null || !line.startsWith("# type: ")) {
            throw new OctaveParseException("Expected '# type: ' got '" + line + "'");
        }
        String typeGlobal = line.substring("# type: ".length());
        String GLOBAL = "global ";
        String type = typeGlobal != null && typeGlobal.startsWith("global ") ? typeGlobal.substring("global ".length()) : typeGlobal;
        OctaveDataReader dataReader = OctaveDataReader.getOctaveDataReader(type);
        if (dataReader == null) {
            throw new OctaveParseException("Unknown octave type, type='" + type + "'");
        }
        return dataReader.read(reader);
    }

    public static Map<String, OctaveObject> readWithName(BufferedReader reader) {
        String line = OctaveIO.readerReadLine(reader);
        String token = "# name: ";
        if (!line.startsWith("# name: ")) {
            throw new OctaveParseException("Expected '# name: ', but got '" + line + "'");
        }
        String name = line.substring("# name: ".length());
        return Collections.singletonMap(name, OctaveIO.read(reader));
    }

    public static Map<String, OctaveObject> readWithName(String input) {
        BufferedReader bufferedReader = new BufferedReader(new StringReader(input));
        Map<String, OctaveObject> map = OctaveIO.readWithName(bufferedReader);
        try {
            String line = bufferedReader.readLine();
            if (line != null) {
                throw new OctaveParseException("Too much data in input, first extra line is '" + line + "'");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return map;
    }

    public static <T extends OctaveObject> void write(Writer writer, T octaveType) throws IOException {
        OctaveDataWriter<T> dataWriter = OctaveDataWriter.getOctaveDataWriter(octaveType);
        if (dataWriter == null) {
            throw new OctaveParseException("Unknown type, " + octaveType.getClass());
        }
        dataWriter.write(writer, octaveType);
    }

    public static void write(Writer writer, String name, OctaveObject octaveType) throws IOException {
        writer.write("# name: " + name + "\n");
        OctaveIO.write(writer, octaveType);
    }

    public static String toText(OctaveObject octaveType, String name) {
        try {
            StringWriter writer = new StringWriter();
            OctaveIO.write(writer, name, octaveType);
            return ((Object)writer).toString();
        }
        catch (IOException e) {
            throw new OctaveIOException(e);
        }
    }

    public static String toText(OctaveObject octaveType) {
        return OctaveIO.toText(octaveType, "ans");
    }
}

