/*
 * Decompiled with CFR 0.152.
 */
package dk.ange.octave.io;

import dk.ange.octave.exception.OctaveIOException;
import dk.ange.octave.exec.WriteFunctor;
import dk.ange.octave.io.OctaveIO;
import dk.ange.octave.type.OctaveObject;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

final class DataWriteFunctor
implements WriteFunctor {
    private static final Log log = LogFactory.getLog(DataWriteFunctor.class);
    final Map<String, OctaveObject> octaveTypes;

    public DataWriteFunctor(Map<String, OctaveObject> octaveTypes) {
        this.octaveTypes = octaveTypes;
    }

    @Override
    public void doWrites(Writer writer) {
        try {
            log.trace((Object)"write: 'load(\"-text\", \"-\")' to start read data from input mode");
            writer.write("load(\"-text\", \"-\")\n");
            for (Map.Entry<String, OctaveObject> entry : this.octaveTypes.entrySet()) {
                String name = entry.getKey();
                OctaveObject value = entry.getValue();
                if (log.isTraceEnabled()) {
                    log.trace((Object)("write: variable '" + name + "', value=<<<" + value + ">>>"));
                }
                OctaveIO.write(writer, name, value);
            }
            log.trace((Object)"write: '# name:' to exit octave from read data mode");
            writer.write("# name: \n");
            writer.flush();
        }
        catch (IOException e) {
            String message = "Unexpected IOException";
            log.debug((Object)"Unexpected IOException", (Throwable)e);
            throw new OctaveIOException("Unexpected IOException", e);
        }
    }
}

