/*
 * Decompiled with CFR 0.152.
 */
package dk.ange.octave.io;

import dk.ange.octave.exception.OctaveParseException;
import dk.ange.octave.exec.ReadFunctor;
import dk.ange.octave.io.OctaveIO;
import dk.ange.octave.type.OctaveObject;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.Map;

final class DataReadFunctor
implements ReadFunctor {
    private final String name;
    private OctaveObject data;

    public DataReadFunctor(String name) {
        this.name = name;
    }

    @Override
    public void doReads(Reader reader) {
        BufferedReader bufferedReader = new BufferedReader(reader);
        String createByOctaveLine = OctaveIO.readerReadLine(bufferedReader);
        if (createByOctaveLine == null || !createByOctaveLine.startsWith("# Created by Octave")) {
            throw new OctaveParseException("Not created by Octave?: '" + createByOctaveLine + "'");
        }
        Map<String, OctaveObject> map = OctaveIO.readWithName(bufferedReader);
        if (map.size() != 1) {
            throw new OctaveParseException("Expected map of size 1 but got " + map + "'");
        }
        if (!map.containsKey(this.name)) {
            throw new OctaveParseException("Expected variable named '" + this.name + "' but got '" + map + "'");
        }
        this.data = map.get(this.name);
    }

    public OctaveObject getData() {
        return this.data;
    }
}

