/*
 * Decompiled with CFR 0.152.
 */
package dk.ange.octave.exec;

import dk.ange.octave.exception.OctaveIOException;
import dk.ange.octave.exec.WriteFunctor;
import java.io.IOException;
import java.io.Writer;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

final class OctaveWriterCallable
implements Callable<Void> {
    private static final Log log = LogFactory.getLog(OctaveWriterCallable.class);
    static final String EXCEPTION_MESSAGE_FUNCTOR = "IOException from WriteFunctor";
    static final String EXCEPTION_MESSAGE_SPACER = "IOException when writing spacer";
    private final Writer processWriter;
    private final WriteFunctor writeFunctor;
    private final String spacer;

    public OctaveWriterCallable(Writer processWriter, WriteFunctor writeFunctor, String spacer) {
        this.processWriter = processWriter;
        this.writeFunctor = writeFunctor;
        this.spacer = spacer;
    }

    @Override
    public Void call() {
        try {
            this.writeFunctor.doWrites(this.processWriter);
        }
        catch (IOException e) {
            log.debug((Object)EXCEPTION_MESSAGE_FUNCTOR, (Throwable)e);
            throw new OctaveIOException(EXCEPTION_MESSAGE_FUNCTOR, e);
        }
        try {
            this.processWriter.write("\nprintf(\"\\n%s\\n\", \"" + this.spacer + "\");\n");
            this.processWriter.flush();
        }
        catch (IOException e) {
            log.debug((Object)EXCEPTION_MESSAGE_SPACER, (Throwable)e);
            throw new OctaveIOException(EXCEPTION_MESSAGE_SPACER, e);
        }
        log.debug((Object)"Has written all");
        return null;
    }
}

