/*
 * Decompiled with CFR 0.152.
 */
package dk.ange.octave.exec;

import dk.ange.octave.exception.OctaveIOException;
import dk.ange.octave.exec.OctaveExecuteReader;
import dk.ange.octave.exec.ReadFunctor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

final class OctaveReaderCallable
implements Callable<Void> {
    private static final Log log = LogFactory.getLog(OctaveReaderCallable.class);
    private final BufferedReader processReader;
    private final ReadFunctor readFunctor;
    private final String spacer;

    public OctaveReaderCallable(BufferedReader processReader, ReadFunctor readFunctor, String spacer) {
        this.processReader = processReader;
        this.readFunctor = readFunctor;
        this.spacer = spacer;
    }

    @Override
    public Void call() {
        OctaveExecuteReader reader = new OctaveExecuteReader(this.processReader, this.spacer);
        try {
            this.readFunctor.doReads(reader);
        }
        catch (IOException e) {
            String message = "IOException from ReadFunctor";
            log.debug((Object)"IOException from ReadFunctor", (Throwable)e);
            throw new OctaveIOException("IOException from ReadFunctor", e);
        }
        finally {
            try {
                ((Reader)reader).close();
            }
            catch (IOException e) {
                String message = "IOException during close";
                log.debug((Object)"IOException during close", (Throwable)e);
                throw new OctaveIOException("IOException during close", e);
            }
        }
        return null;
    }
}

