/*
 * Decompiled with CFR 0.152.
 */
package dk.ange.octave.exec;

import dk.ange.octave.util.StringUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

final class OctaveExecuteReader
extends Reader {
    private static final Log log = LogFactory.getLog(OctaveExecuteReader.class);
    private final BufferedReader octaveReader;
    private final String spacer;
    private StringBuffer buffer;
    private boolean firstLine = true;
    private boolean eof = false;

    public OctaveExecuteReader(BufferedReader octaveReader, String spacer) {
        this.octaveReader = octaveReader;
        this.spacer = spacer;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.eof) {
            return -1;
        }
        if (this.buffer == null) {
            String line = this.octaveReader.readLine();
            if (log.isTraceEnabled()) {
                log.trace((Object)("octaveReader.readLine() = " + StringUtil.jQuote(line)));
            }
            if (line == null) {
                throw new IOException("Pipe to octave-process broken");
            }
            if (this.spacer.equals(line)) {
                this.eof = true;
                return -1;
            }
            this.buffer = new StringBuffer(line.length() + 1);
            if (this.firstLine) {
                this.firstLine = false;
            } else {
                this.buffer.append('\n');
            }
            this.buffer.append(line);
        }
        int charsRead = Math.min(this.buffer.length(), len);
        this.buffer.getChars(0, charsRead, cbuf, off);
        if (charsRead == this.buffer.length()) {
            this.buffer = null;
        } else {
            this.buffer.delete(0, charsRead);
        }
        return charsRead;
    }

    @Override
    public void close() throws IOException {
        char[] buffer1 = new char[4096];
        while (this.read(buffer1) != -1) {
        }
        if (this.octaveReader.ready()) {
            throw new IOException("octaveReader is ready()");
        }
        log.debug((Object)"Reader closed()");
    }
}

