/*
 * Decompiled with CFR 0.152.
 */
package dk.ange.octave.exec;

import dk.ange.octave.exception.OctaveException;
import dk.ange.octave.exception.OctaveIOException;
import dk.ange.octave.exec.OctaveReaderCallable;
import dk.ange.octave.exec.OctaveWriterCallable;
import dk.ange.octave.exec.ReadFunctor;
import dk.ange.octave.exec.WriteFunctor;
import dk.ange.octave.util.NamedThreadFactory;
import dk.ange.octave.util.NoCloseWriter;
import dk.ange.octave.util.ReaderWriterPipeThread;
import dk.ange.octave.util.TeeWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Random;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class OctaveExec {
    public static final String PROPERTY_EXECUTABLE = "dk.ange.octave.executable";
    private static final Log log = LogFactory.getLog(OctaveExec.class);
    private static final String[] CMD_ARRAY = new String[]{null, "--no-history", "--no-init-file", "--no-line-editing", "--no-site-file", "--silent"};
    private final Process process;
    private final Writer processWriter;
    private final BufferedReader processReader;
    private final ExecutorService executor = Executors.newFixedThreadPool(2, new NamedThreadFactory(OctaveExec.class.getSimpleName()));
    private final ReaderWriterPipeThread errorStreamThread;
    private boolean destroyed = false;
    private final Random random = new Random();

    public OctaveExec(Writer stdinLog, Writer stderrLog, File octaveProgram, String[] environment, File workingDir) {
        String[] cmdArray = (String[])CMD_ARRAY.clone();
        cmdArray[0] = octaveProgram != null ? octaveProgram.getPath() : System.getProperty(PROPERTY_EXECUTABLE, "octave");
        try {
            this.process = Runtime.getRuntime().exec(cmdArray, environment, workingDir);
        }
        catch (IOException e) {
            throw new OctaveIOException(e);
        }
        this.errorStreamThread = ReaderWriterPipeThread.instantiate(new InputStreamReader(this.process.getErrorStream()), stderrLog);
        this.processReader = new BufferedReader(new InputStreamReader(this.process.getInputStream(), Charset.forName("Latin1")));
        this.processWriter = stdinLog == null ? new OutputStreamWriter(this.process.getOutputStream()) : new TeeWriter(new NoCloseWriter(stdinLog), new OutputStreamWriter(this.process.getOutputStream()));
    }

    private String generateSpacer() {
        return "-=+X+=- Octave.java spacer -=+X+=- " + this.random.nextLong() + " -=+X+=-";
    }

    public void eval(WriteFunctor input, ReadFunctor output) {
        String spacer = this.generateSpacer();
        Future<Void> writerFuture = this.executor.submit(new OctaveWriterCallable(this.processWriter, input, spacer));
        Future<Void> readerFuture = this.executor.submit(new OctaveReaderCallable(this.processReader, output, spacer));
        RuntimeException writerException = this.getFromFuture(writerFuture);
        if (writerException instanceof CancellationException) {
            log.error((Object)"Did not expect writer to be canceled", (Throwable)writerException);
        }
        if (writerException != null) {
            if (writerException instanceof CancellationException) {
                log.error((Object)"Did not expect writer to be canceled", (Throwable)writerException);
            }
            readerFuture.cancel(true);
        }
        RuntimeException readerException = this.getFromFuture(readerFuture);
        if (writerException != null) {
            throw writerException;
        }
        if (readerException != null) {
            if (readerException instanceof CancellationException) {
                log.error((Object)"Did not expect reader to be canceled", (Throwable)writerException);
            }
            throw readerException;
        }
    }

    private RuntimeException getFromFuture(Future<Void> future) {
        try {
            future.get();
        }
        catch (InterruptedException e) {
            String message = "InterruptedException should not happen";
            log.error((Object)"InterruptedException should not happen", (Throwable)e);
            return new RuntimeException("InterruptedException should not happen", e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof OctaveException) {
                OctaveException oe = (OctaveException)e.getCause();
                return this.reInstantiateException(oe);
            }
            String message = "ExecutionException should not happen";
            log.error((Object)"ExecutionException should not happen", (Throwable)e);
            return new RuntimeException("ExecutionException should not happen", e);
        }
        catch (CancellationException e) {
            return e;
        }
        catch (RuntimeException e) {
            String message = "RuntimeException should not happen";
            log.error((Object)"RuntimeException should not happen", (Throwable)e);
            return new RuntimeException("RuntimeException should not happen", e);
        }
        return null;
    }

    private OctaveException reInstantiateException(OctaveException inException) {
        OctaveException outException;
        try {
            outException = (OctaveException)inException.getClass().getConstructor(String.class, Throwable.class).newInstance(inException.getMessage(), inException);
        }
        catch (Exception e) {
            throw new IllegalStateException("Exception should not happen", e);
        }
        if (this.isDestroyed()) {
            outException.setDestroyed(true);
        }
        return outException;
    }

    private synchronized void setDestroyed(boolean destroyed) {
        this.destroyed = destroyed;
    }

    private synchronized boolean isDestroyed() {
        return this.destroyed;
    }

    public void destroy() {
        this.setDestroyed(true);
        this.executor.shutdownNow();
        this.process.destroy();
        this.errorStreamThread.close();
        try {
            this.processWriter.close();
        }
        catch (IOException e) {
            throw new OctaveIOException(e);
        }
    }

    public void close() {
        try {
            int exitValue;
            this.processWriter.write("exit\n");
            this.processWriter.close();
            String read1 = this.processReader.readLine();
            if (read1 != null && !"".equals(read1)) {
                throw new OctaveIOException("Expected a blank line, read '" + read1 + "'");
            }
            String read2 = this.processReader.readLine();
            if (read2 != null) {
                throw new OctaveIOException("Expected reader to be at end of stream, read '" + read2 + "'");
            }
            this.processReader.close();
            this.errorStreamThread.close();
            try {
                exitValue = this.process.waitFor();
            }
            catch (InterruptedException e) {
                throw new OctaveIOException("Interrupted when waiting for octave process to terminate", e);
            }
            if (exitValue != 0) {
                throw new OctaveIOException("octave process terminated abnormaly, exitValue=" + exitValue);
            }
        }
        catch (IOException e) {
            OctaveIOException octaveException = new OctaveIOException("reader error", e);
            if (this.isDestroyed()) {
                octaveException.setDestroyed(true);
            }
            throw octaveException;
        }
        finally {
            this.executor.shutdown();
        }
    }

    public void setErrorWriter(Writer writer) {
        this.errorStreamThread.setWriter(writer);
    }
}

