/*
 * Decompiled with CFR 0.152.
 */
package dk.ange.octave;

import dk.ange.octave.OctaveEngine;
import dk.ange.octave.type.OctaveCell;
import dk.ange.octave.type.OctaveString;
import java.util.Collection;
import java.util.HashSet;
import java.util.Random;
import java.util.regex.Pattern;

public final class OctaveUtils {
    private static final Random random = new Random();

    private OctaveUtils() {
        throw new UnsupportedOperationException("Do not instantiate");
    }

    public static Collection<String> listVars(OctaveEngine octave) {
        String varName = OctaveUtils.randomVarName();
        octave.eval(String.format("%1$s = cell(0, 1);\nif strncmp(OCTAVE_VERSION(), \"3.0.\", 4)\n  %1$s_1 = whos -v;\nelse\n  %1$s_1 = whos;\nendif\nfor %1$s_2 = 1 : numel(%1$s_1)\n  %1$s{%1$s_2} = %1$s_1(%1$s_2).name;\nendfor\nclear %1$s_1 %1$s_2\n", varName));
        OctaveCell data = octave.get(OctaveCell.class, varName);
        octave.eval("clear " + varName);
        HashSet<String> collection = new HashSet<String>();
        Pattern pattern = Pattern.compile("javaoctave_[0-9a-f]{12}_eval");
        for (int i = 1; i <= data.size(2); ++i) {
            String name = data.get(OctaveString.class, 1, i).getString();
            if (varName.equals(name) || "__nargin__".equals(name) || "ans".equals(name) || pattern.matcher(name).matches()) continue;
            collection.add(name);
        }
        return collection;
    }

    private static synchronized int nextInt() {
        return random.nextInt(0x40000000);
    }

    private static String randomVarName() {
        return String.format("_OctaveUtils_%d", OctaveUtils.nextInt());
    }
}

