/*
 * Decompiled with CFR 0.152.
 */
package dk.ange.octave;

import dk.ange.octave.OctaveEngineFactory;
import dk.ange.octave.exception.OctaveEvalException;
import dk.ange.octave.exec.OctaveExec;
import dk.ange.octave.exec.ReadFunctor;
import dk.ange.octave.exec.ReaderWriteFunctor;
import dk.ange.octave.exec.WriteFunctor;
import dk.ange.octave.exec.WriterReadFunctor;
import dk.ange.octave.io.OctaveIO;
import dk.ange.octave.type.OctaveObject;
import dk.ange.octave.type.OctaveString;
import dk.ange.octave.type.cast.Cast;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.Map;
import java.util.Random;

public final class OctaveEngine {
    private final OctaveEngineFactory factory;
    private final OctaveExec octaveExec;
    private final OctaveIO octaveIO;
    private Writer writer = new OutputStreamWriter(System.out);
    private final Random random = new Random();

    OctaveEngine(OctaveEngineFactory factory, Writer octaveInputLog, Writer errorWriter, File octaveProgram, File workingDir) {
        this.factory = factory;
        this.octaveExec = new OctaveExec(octaveInputLog, errorWriter, octaveProgram, null, workingDir);
        this.octaveIO = new OctaveIO(this.octaveExec);
    }

    public void unsafeEval(final String script) {
        this.octaveExec.eval(new WriteFunctor(){

            @Override
            public void doWrites(Writer writer2) throws IOException {
                writer2.write(script);
            }
        }, this.getReadFunctor());
    }

    private ReadFunctor getReadFunctor() {
        if (this.writer == null) {
            return new ReadFunctor(){
                private final char[] buffer = new char[4096];

                @Override
                public void doReads(Reader reader) throws IOException {
                    while (reader.read(this.buffer) != -1) {
                    }
                }
            };
        }
        return new WriterReadFunctor(this.writer);
    }

    public void unsafeEval(Reader script) {
        this.octaveExec.eval(new ReaderWriteFunctor(script), this.getReadFunctor());
    }

    public void eval(String script) {
        String tag = String.format("%06x%06x", this.random.nextInt(0x800000), this.random.nextInt(0x800000));
        this.put(String.format("javaoctave_%1$s_eval", tag), new OctaveString(script));
        this.unsafeEval(String.format("eval(javaoctave_%1$s_eval, \"javaoctave_%1$s_lasterr = lasterr();\");", tag));
        OctaveString lastError = this.get(OctaveString.class, String.format("javaoctave_%1$s_lasterr", tag));
        this.unsafeEval(String.format("clear javaoctave_%1$s_eval javaoctave_%1$s_lasterr", tag));
        if (lastError != null) {
            throw new OctaveEvalException(lastError.getString());
        }
    }

    public void put(String key, OctaveObject value) {
        this.octaveIO.set(Collections.singletonMap(key, value));
    }

    public void putAll(Map<String, OctaveObject> vars) {
        this.octaveIO.set(vars);
    }

    public OctaveObject get(String key) {
        return this.octaveIO.get(key);
    }

    public <T extends OctaveObject> T get(Class<T> castClass, String key) {
        return Cast.cast(castClass, this.get(key));
    }

    public OctaveEngineFactory getFactory() {
        return this.factory;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public void setErrorWriter(Writer errorWriter) {
        this.octaveExec.setErrorWriter(errorWriter);
    }

    public void close() {
        this.octaveExec.close();
    }

    public void destroy() {
        this.octaveExec.destroy();
    }

    public String getVersion() {
        StringWriter version = new StringWriter();
        this.octaveExec.eval(new ReaderWriteFunctor(new StringReader("printf(\"%s\", OCTAVE_VERSION());")), new WriterReadFunctor(version));
        return version.toString();
    }
}

